/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.MultipleRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.ArrayList;
import java.util.List;

public class ListRevocationSource<R extends Revocation>
implements MultipleRevocationSource<R> {
    private static final long serialVersionUID = -6284731668494875108L;
    private List<OfflineRevocationSource<R>> sources = new ArrayList<OfflineRevocationSource<R>>();

    public ListRevocationSource() {
    }

    public ListRevocationSource(OfflineRevocationSource<R> revocationSource) {
        this.add(revocationSource);
    }

    public void add(OfflineRevocationSource<R> revocationSource) {
        this.sources.add(revocationSource);
    }

    public void addAll(ListRevocationSource<R> listRevocationSource) {
        this.addAll(listRevocationSource.getSources());
    }

    public void addAll(List<OfflineRevocationSource<R>> revocationSources) {
        this.sources.addAll(revocationSources);
    }

    public List<OfflineRevocationSource<R>> getSources() {
        return this.sources;
    }

    public boolean isEmpty() {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            if (revocationSource.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<RevocationToken<R>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        ArrayList<RevocationToken<R>> result = new ArrayList<RevocationToken<R>>();
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            result.addAll(revocationSource.getRevocationTokens(certificateToken, issuerCertificateToken));
        }
        return result;
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getAllRevocationBinaries() {
        ArrayList<EncapsulatedRevocationTokenIdentifier<R>> result = new ArrayList<EncapsulatedRevocationTokenIdentifier<R>>();
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            result.addAll(revocationSource.getAllRevocationBinaries());
        }
        return result;
    }

    public EncapsulatedRevocationTokenIdentifier<R> findBinaryForReference(RevocationRef<R> reference) {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            EncapsulatedRevocationTokenIdentifier<R> tokenIdentifier = revocationSource.findBinaryForReference(reference);
            if (tokenIdentifier == null) continue;
            return tokenIdentifier;
        }
        return null;
    }

    public boolean isOrphan(RevocationRef<R> reference) {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            if (revocationSource.isOrphan(reference)) continue;
            return false;
        }
        return true;
    }
}

