/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunnableAnalysis
extends AbstractAnalysis
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRunnableAnalysis.class);
    private static final String LOG_ERROR_PERFORM_ANALYSIS = "Error performing analysis.";
    private final CountDownLatch latch;

    protected AbstractRunnableAnalysis(CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader, CountDownLatch latch) {
        super(cacheAccess, dssFileLoader);
        this.latch = latch;
    }

    protected abstract void doAnalyze();

    @Override
    public void run() {
        try {
            this.doAnalyze();
        }
        catch (Throwable exception) {
            LOG.error(LOG_ERROR_PERFORM_ANALYSIS, exception);
        }
        finally {
            this.latch.countDown();
        }
    }
}

