/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.standalone.RemoteDocumentSignatureServiceBuilder;
import eu.europa.esig.dss.standalone.RemoteTrustedListSignatureServiceBuilder;
import eu.europa.esig.dss.standalone.enumeration.SignatureOption;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.standalone.model.SignatureModel;
import eu.europa.esig.dss.standalone.task.SelectCertificateTask;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.common.RemoteTrustedListSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteBLevelParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTrustedListSignatureParameters;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.trustedlist.TrustedListUtils;
import eu.europa.esig.xmldsig.XmlDSigUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SigningTask
extends Task<DSSDocument> {
    private static final String TRUSTED_LIST_PARENT_ELEMENT = "TrustServiceStatusList";
    private static final String TRUSTED_LIST_NAMESPACE = "http://uri.etsi.org/02231/v2#";
    private final SignatureModel model;
    private final RemoteDocumentSignatureService service;
    private final RemoteTrustedListSignatureService trustedListSignatureService;

    public SigningTask(SignatureModel model, TrustedListsCertificateSource tslCertificateSource) {
        this.model = model;
        RemoteDocumentSignatureServiceBuilder signatureServiceBuilder = new RemoteDocumentSignatureServiceBuilder();
        signatureServiceBuilder.setTslCertificateSource(tslCertificateSource);
        this.service = signatureServiceBuilder.build();
        RemoteTrustedListSignatureServiceBuilder trustedListServiceBuilder = new RemoteTrustedListSignatureServiceBuilder();
        this.trustedListSignatureService = trustedListServiceBuilder.build();
    }

    @Override
    protected DSSDocument call() throws Exception {
        DSSDocument signedDocument;
        this.updateProgress(0L, 100L);
        SignatureTokenConnection token = this.getToken(this.model);
        this.updateProgress(5L, 100L);
        List<DSSPrivateKeyEntry> keys = token.getKeys();
        this.updateProgress(10L, 100L);
        DSSPrivateKeyEntry signer = this.getSigner(keys);
        FileDocument fileToSign = new FileDocument(this.model.getFileToSign());
        RemoteDocument toSignDocument = RemoteDocumentConverter.toRemoteDocument(fileToSign);
        if (this.isTLSigning(fileToSign)) {
            RemoteTrustedListSignatureParameters parameters = this.buildTrustedListParameters(signer);
            ToBeSigned toBeSigned = this.getDataToSignTrustedList(toSignDocument, parameters);
            SignatureValueDTO signatureValue = this.sign(token, signer, toBeSigned);
            signedDocument = this.signTrustedList(toSignDocument, parameters, signatureValue);
        } else {
            RemoteSignatureParameters parameters = this.buildParameters(signer);
            ToBeSigned toBeSigned = this.getDataToSign(toSignDocument, parameters);
            SignatureValueDTO signatureValue = this.sign(token, signer, toBeSigned);
            signedDocument = this.signDocument(toSignDocument, parameters, signatureValue);
        }
        this.updateProgress(100L, 100L);
        return signedDocument;
    }

    private RemoteSignatureParameters buildParameters(DSSPrivateKeyEntry signer) {
        this.updateProgress(20L, 100L);
        RemoteSignatureParameters parameters = new RemoteSignatureParameters();
        parameters.setAsicContainerType(this.model.getAsicContainerType());
        parameters.setDigestAlgorithm(this.model.getDigestAlgorithm());
        parameters.setSignatureLevel(this.model.getSignatureLevel());
        parameters.setSignaturePackaging(this.model.getSignaturePackaging());
        RemoteBLevelParameters bLevelParams = new RemoteBLevelParameters();
        bLevelParams.setSigningDate(new Date());
        parameters.setBLevelParams(bLevelParams);
        parameters.setSigningCertificate(new RemoteCertificate(signer.getCertificate().getEncoded()));
        parameters.setEncryptionAlgorithm(signer.getEncryptionAlgorithm());
        Object[] certificateChain = signer.getCertificateChain();
        if (Utils.isArrayNotEmpty(certificateChain)) {
            ArrayList<RemoteCertificate> certificateChainList = new ArrayList<RemoteCertificate>();
            for (Object certificateToken : certificateChain) {
                certificateChainList.add(new RemoteCertificate(((CertificateToken)certificateToken).getEncoded()));
            }
            parameters.setCertificateChain(certificateChainList);
        }
        if (this.isXmlManifestSigning()) {
            parameters.setManifestSignature(true);
        }
        if (SignatureForm.JAdES.equals((Object)this.model.getSignatureForm())) {
            parameters.setJwsSerializationType(JWSSerializationType.JSON_SERIALIZATION);
            parameters.setSigDMechanism(SigDMechanism.OBJECT_ID_BY_URI_HASH);
        }
        return parameters;
    }

    private RemoteTrustedListSignatureParameters buildTrustedListParameters(DSSPrivateKeyEntry signer) {
        this.updateProgress(20L, 100L);
        RemoteTrustedListSignatureParameters parameters = new RemoteTrustedListSignatureParameters();
        RemoteBLevelParameters bLevelParams = new RemoteBLevelParameters();
        bLevelParams.setSigningDate(new Date());
        parameters.setBLevelParameters(bLevelParams);
        parameters.setSigningCertificate(new RemoteCertificate(signer.getCertificate().getEncoded()));
        parameters.setReferenceDigestAlgorithm(this.model.getDigestAlgorithm());
        return parameters;
    }

    private boolean isTLSigning(FileDocument toBeSigned) {
        SignatureOption signatureOption = this.model.getSignatureOption();
        if (SignatureOption.TL_SIGNING.equals((Object)signatureOption)) {
            if (DomUtils.isDOM(toBeSigned)) {
                Document document = DomUtils.buildDOM(toBeSigned);
                Element documentElement = document.getDocumentElement();
                if (TRUSTED_LIST_PARENT_ELEMENT.equals(documentElement.getLocalName()) && TRUSTED_LIST_NAMESPACE.equals(documentElement.getNamespaceURI())) {
                    List<String> errors = DSSXMLUtils.validateAgainstXSD(TrustedListUtils.getInstance(), new DOMSource(document));
                    if (Utils.isCollectionEmpty(errors)) {
                        return true;
                    }
                    this.throwException(String.format("The provided file is not a valid Trusted List! %s", errors.toString()), null);
                } else {
                    this.throwException("The provided file is not a Trusted List!", null);
                }
            } else {
                this.throwException("The provided file is not an XML!", null);
            }
        }
        return false;
    }

    private boolean isXmlManifestSigning() {
        SignatureOption signatureOption = this.model.getSignatureOption();
        if (SignatureOption.XML_MANIFEST_SIGNING.equals((Object)signatureOption)) {
            FileDocument fileToSign = new FileDocument(this.model.getFileToSign());
            if (DomUtils.isDOM(fileToSign)) {
                Element document = DomUtils.buildDOM(fileToSign).getDocumentElement();
                if (XMLDSigElement.MANIFEST.isSameTagName(document.getLocalName()) && XAdESNamespaces.XMLDSIG.isSameUri(document.getNamespaceURI())) {
                    List<String> errors = DSSXMLUtils.validateAgainstXSD(XmlDSigUtils.getInstance(), new DOMSource(document));
                    if (Utils.isCollectionEmpty(errors)) {
                        return true;
                    }
                    this.throwException(String.format("The provided file is not a valid XML Manifest! %s", errors.toString()), null);
                    return true;
                }
                this.throwException("The provided file is not an XML Manifest!", null);
            } else {
                this.throwException("The provided file is not an XML!", null);
            }
        }
        return false;
    }

    private ToBeSigned getDataToSign(RemoteDocument toSignDocument, RemoteSignatureParameters parameters) {
        this.updateProgress(25L, 100L);
        ToBeSigned toBeSigned = null;
        try {
            toBeSigned = DTOConverter.toToBeSigned(this.service.getDataToSign(toSignDocument, parameters));
        }
        catch (Exception e) {
            this.throwException("Unable to compute the digest to sign", e);
        }
        return toBeSigned;
    }

    private ToBeSigned getDataToSignTrustedList(RemoteDocument toSignDocument, RemoteTrustedListSignatureParameters parameters) {
        this.updateProgress(25L, 100L);
        ToBeSigned toBeSigned = null;
        try {
            toBeSigned = DTOConverter.toToBeSigned(this.trustedListSignatureService.getDataToSign(toSignDocument, parameters));
        }
        catch (Exception e) {
            this.throwException("Unable to compute the digest to sign", e);
        }
        return toBeSigned;
    }

    private SignatureValueDTO sign(SignatureTokenConnection token, DSSPrivateKeyEntry signer, ToBeSigned toBeSigned) {
        this.updateProgress(50L, 100L);
        SignatureValue signatureValue = null;
        try {
            signatureValue = token.sign(toBeSigned, this.model.getDigestAlgorithm(), signer);
        }
        catch (Exception e) {
            this.throwException("Unable to sign the digest", e);
        }
        return new SignatureValueDTO(signatureValue.getAlgorithm(), signatureValue.getValue());
    }

    private DSSDocument signDocument(RemoteDocument toSignDocument, RemoteSignatureParameters parameters, SignatureValueDTO signatureValue) {
        this.updateProgress(75L, 100L);
        DSSDocument signDocument = null;
        try {
            signDocument = RemoteDocumentConverter.toDSSDocument(this.service.signDocument(toSignDocument, parameters, signatureValue));
        }
        catch (Exception e) {
            this.throwException("Unable to sign the document", e);
        }
        return signDocument;
    }

    private DSSDocument signTrustedList(RemoteDocument toSignDocument, RemoteTrustedListSignatureParameters parameters, SignatureValueDTO signatureValue) {
        this.updateProgress(75L, 100L);
        DSSDocument signDocument = null;
        try {
            signDocument = RemoteDocumentConverter.toDSSDocument(this.trustedListSignatureService.signDocument(toSignDocument, parameters, signatureValue));
        }
        catch (Exception e) {
            this.throwException("Unable to sign the document", e);
        }
        return signDocument;
    }

    private DSSPrivateKeyEntry getSigner(List<DSSPrivateKeyEntry> keys) throws Exception {
        DSSPrivateKeyEntry selectedKey = null;
        if (Utils.isCollectionEmpty(keys)) {
            this.throwException("No certificate found", null);
        } else if (Utils.collectionSize(keys) == 1) {
            selectedKey = keys.get(0);
        } else {
            FutureTask<DSSPrivateKeyEntry> future = new FutureTask<DSSPrivateKeyEntry>(new SelectCertificateTask(keys));
            Platform.runLater(future);
            selectedKey = future.get();
            if (selectedKey == null) {
                this.throwException("No selected certificate", null);
            }
        }
        return selectedKey;
    }

    private SignatureTokenConnection getToken(SignatureModel model) throws IOException {
        switch (model.getTokenType()) {
            case PKCS11: {
                return new Pkcs11SignatureToken(model.getPkcsFile().getAbsolutePath(), new KeyStore.PasswordProtection(model.getPassword().toCharArray()));
            }
            case PKCS12: {
                return new Pkcs12SignatureToken(model.getPkcsFile(), new KeyStore.PasswordProtection(model.getPassword().toCharArray()));
            }
            case MSCAPI: {
                return new MSCAPISignatureToken();
            }
        }
        throw new IllegalArgumentException("Unsupported token type " + model.getTokenType());
    }

    private void throwException(String message, Exception e) {
        String exceptionMessage = message + (String)(e != null ? " : " + e.getMessage() : "");
        this.updateMessage(exceptionMessage);
        this.failed();
        this.updateProgress(0L, 100L);
        throw new ApplicationException(exceptionMessage, e);
    }
}

