/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature.resources;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.signature.resources.AbstractResourcesHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileResourcesHandler
extends AbstractResourcesHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TempFileResourcesHandler.class);
    private final File tempFile;
    private boolean toBeDeleted = true;

    public TempFileResourcesHandler(String fileNamePrefix, String fileNameSuffix, File tempFileDirectory) {
        try {
            this.tempFile = Files.createTempFile(tempFileDirectory.toPath(), fileNamePrefix, fileNameSuffix, new FileAttribute[0]).toFile();
            this.tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to create a temporary file. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    protected OutputStream buildOutputStream() throws IOException {
        this.assertFileExists();
        return new BufferedOutputStream(Files.newOutputStream(this.tempFile.toPath(), new OpenOption[0]));
    }

    @Override
    public DSSDocument writeToDSSDocument() {
        this.assertFileExists();
        this.toBeDeleted = false;
        return new FileDocument(this.tempFile);
    }

    private void assertFileExists() {
        if (!this.tempFile.exists()) {
            throw new IllegalStateException(String.format("The file '%s' does not exists!", this.tempFile.getName()));
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.toBeDeleted) {
            this.forceDelete();
        }
    }

    public void forceDelete() {
        boolean deleted;
        if (this.tempFile != null && !(deleted = this.tempFile.delete())) {
            LOG.warn("Unable to remove a temporary file '{}'", (Object)this.tempFile.getName());
        }
    }
}

