/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pdf.AbstractPDFSignatureService;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.encryption.DSSSecureRandomProvider;
import eu.europa.esig.dss.pdf.encryption.SecureRandomProvider;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocumentReader;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawerFactory;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.NativePdfBoxVisibleSignatureDrawer;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDPropBuild;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDPropBuildDataDict;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxSignatureService
extends AbstractPDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxSignatureService.class);
    private SecureRandomProvider secureRandomProvider;

    public void setSecureRandomProvider(SecureRandomProvider secureRandomProvider) {
        Objects.requireNonNull(secureRandomProvider, "SecureRandomProvider cannot be null");
        this.secureRandomProvider = secureRandomProvider;
    }

    public PdfBoxSignatureService(PDFServiceMode serviceMode, PdfBoxSignatureDrawerFactory signatureDrawerFactory) {
        super(serviceMode, signatureDrawerFactory);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] computeDigest(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DSSDocument signDocument(DSSDocument toSignDocument, byte[] cmsSignedData, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] signDocumentAndReturnDigest(PAdESCommonParameters parameters, final byte[] cmsSignedData, OutputStream outputStream, PdfBoxDocumentReader documentReader) {
        byte[] byArray;
        PDDocument pdDocument = documentReader.getPDDocument();
        final MessageDigest digest = DSSUtils.getMessageDigest(parameters.getDigestAlgorithm());
        SignatureInterface signatureInterface = new SignatureInterface(){

            @Override
            public byte[] sign(InputStream content) throws IOException {
                int count;
                byte[] b = new byte[4096];
                while ((count = content.read(b)) > 0) {
                    digest.update(b, 0, count);
                }
                return cmsSignedData;
            }
        };
        SignatureFieldParameters fieldParameters = parameters.getImageParameters().getFieldParameters();
        PDSignature pdSignature = this.createSignatureDictionary(pdDocument, parameters);
        PDSignatureField pdSignatureField = this.findExistingSignatureField(pdDocument, fieldParameters);
        if (pdSignatureField != null) {
            this.setSignatureToField(pdSignatureField, pdSignature);
        }
        SignatureOptions options = new SignatureOptions();
        try {
            options.setPreferredSignatureSize(parameters.getContentSize());
            SignatureImageParameters imageParameters = parameters.getImageParameters();
            if (!imageParameters.isEmpty()) {
                PdfBoxSignatureDrawer signatureDrawer = (PdfBoxSignatureDrawer)this.loadSignatureDrawer(imageParameters);
                signatureDrawer.init(imageParameters, pdDocument, options);
                if (signatureDrawer instanceof NativePdfBoxVisibleSignatureDrawer) {
                    ((NativePdfBoxVisibleSignatureDrawer)signatureDrawer).setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
                }
                if (pdSignatureField == null) {
                    this.getVisibleSignatureFieldBoxPosition(signatureDrawer, documentReader, fieldParameters);
                }
                signatureDrawer.draw();
            }
            pdDocument.addSignature(pdSignature, signatureInterface, options);
            if (pdDocument.getDocumentId() == null) {
                pdDocument.setDocumentId(parameters.getSigningDate().getTime());
            }
            this.checkEncryptedAndSaveIncrementally(pdDocument, outputStream, parameters);
            byArray = digest.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    options.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to compute digest for a PDF : %s", e.getMessage()), e);
            }
        }
        options.close();
        return byArray;
    }

    private PDSignatureField findExistingSignatureField(PDDocument pdDocument, SignatureFieldParameters fieldParameters) {
        String targetFieldId = fieldParameters.getFieldId();
        if (!this.isDocumentTimestampLayer() && Utils.isStringNotEmpty(targetFieldId)) {
            PDField field;
            PDAcroForm acroForm = pdDocument.getDocumentCatalog().getAcroForm();
            if (acroForm != null && (field = acroForm.getField(targetFieldId)) != null) {
                if (field instanceof PDSignatureField) {
                    PDSignatureField signatureField = (PDSignatureField)field;
                    PDSignature signature = signatureField.getSignature();
                    if (signature != null) {
                        throw new IllegalArgumentException(String.format("The signature field '%s' can not be signed since its already signed.", targetFieldId));
                    }
                    return signatureField;
                }
                throw new IllegalArgumentException(String.format("The field '%s' is not a signature field!", targetFieldId));
            }
            throw new IllegalArgumentException(String.format("The signature field '%s' does not exist.", targetFieldId));
        }
        return null;
    }

    protected PDSignature createSignatureDictionary(PDDocument pdDocument, PAdESCommonParameters parameters) {
        PDSignature signature = new PDSignature();
        COSName currentType = COSName.getPDFName(this.getType());
        signature.setType(currentType);
        if (Utils.isStringNotEmpty(parameters.getFilter())) {
            signature.setFilter(COSName.getPDFName(parameters.getFilter()));
        }
        if (Utils.isStringNotEmpty(parameters.getSubFilter())) {
            signature.setSubFilter(COSName.getPDFName(parameters.getSubFilter()));
        }
        if (Utils.isStringNotEmpty(parameters.getAppName())) {
            PDPropBuild propBuild = new PDPropBuild(new COSDictionary());
            PDPropBuildDataDict app = new PDPropBuildDataDict();
            app.setName(parameters.getAppName());
            propBuild.setPDPropBuildApp(app);
            signature.setPropBuild(propBuild);
        }
        if (COSName.SIG.equals(currentType)) {
            CertificationPermission permission;
            PAdESSignatureParameters signatureParameters = (PAdESSignatureParameters)parameters;
            if (Utils.isStringNotEmpty(signatureParameters.getSignerName())) {
                signature.setName(signatureParameters.getSignerName());
            }
            if (Utils.isStringNotEmpty(signatureParameters.getContactInfo())) {
                signature.setContactInfo(signatureParameters.getContactInfo());
            }
            if (Utils.isStringNotEmpty(signatureParameters.getLocation())) {
                signature.setLocation(signatureParameters.getLocation());
            }
            if (Utils.isStringNotEmpty(signatureParameters.getReason())) {
                signature.setReason(signatureParameters.getReason());
            }
            if ((permission = signatureParameters.getPermission()) != null && !this.containsFilledSignature(pdDocument)) {
                this.setMDPPermission(pdDocument, signature, permission.getCode());
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(signatureParameters.getSigningDate());
            cal.setTimeZone(signatureParameters.getSigningTimeZone());
            signature.setSignDate(cal);
        }
        return signature;
    }

    private void setSignatureToField(PDSignatureField pdSignatureField, PDSignature pdSignature) {
        pdSignatureField.getCOSObject().setItem(COSName.V, (COSObjectable)pdSignature);
    }

    private boolean containsFilledSignature(PDDocument pdDocument) {
        try {
            List<PDSignature> signatures = pdDocument.getSignatureDictionaries();
            for (PDSignature pdSignature : signatures) {
                if (!pdSignature.getCOSObject().containsKey(COSName.BYTERANGE)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.warn("Cannot read the existing signature(s)", e);
            return false;
        }
    }

    protected void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) {
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("TransformParams"));
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add(referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    public void checkEncryptedAndSaveIncrementally(PDDocument pdDocument, OutputStream outputStream, PAdESCommonParameters parameters) {
        try {
            if (pdDocument.isEncrypted()) {
                SecureRandom secureRandom = this.getSecureRandomProvider(parameters).getSecureRandom();
                pdDocument.getEncryption().getSecurityHandler().setCustomSecureRandom(secureRandom);
            }
            this.saveDocumentIncrementally(pdDocument, outputStream);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to save a document. Reason : %s", e.getMessage()), e);
        }
    }

    public void saveDocumentIncrementally(PDDocument pdDocument, OutputStream outputStream) {
        try {
            pdDocument.saveIncremental(outputStream);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to save a document. Reason : %s", e.getMessage()), e);
        }
    }

    private SecureRandomProvider getSecureRandomProvider(PAdESCommonParameters parameters) {
        if (this.secureRandomProvider == null) {
            this.secureRandomProvider = new DSSSecureRandomProvider(parameters);
        }
        return this.secureRandomProvider;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument addDssDictionary(DSSDocument document, PdfValidationDataContainer validationDataForInclusion, String pwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private COSDictionary buildDSSDictionary(PDDocument pdDocument, PdfValidationDataContainer validationDataForInclusion) throws IOException {
        Collection<TimestampToken> detachedTimestamps;
        COSDictionary dss = new COSDictionary();
        COSArray certs = new COSArray();
        COSArray crls = new COSArray();
        COSArray ocsps = new COSArray();
        HashMap<String, COSBase> knownObjects = new HashMap<String, COSBase>();
        Collection<AdvancedSignature> signatures = validationDataForInclusion.getSignatures();
        if (Utils.isCollectionNotEmpty(signatures)) {
            COSDictionary vriDictionary = new COSDictionary();
            for (AdvancedSignature signature : signatures) {
                Set<OCSPToken> ocspTokensToAdd;
                Set<CRLToken> crlTokensToAdd;
                COSDictionary sigVriDictionary = new COSDictionary();
                sigVriDictionary.setDirect(true);
                ValidationData validationData = new ValidationData();
                ValidationData signatureValidationData = validationDataForInclusion.getAllValidationDataForSignature(signature);
                validationData.addValidationData(signatureValidationData);
                if (validationData.isEmpty()) continue;
                Set<CertificateToken> certificateTokensToAdd = validationData.getCertificateTokens();
                if (Utils.isCollectionNotEmpty(certificateTokensToAdd)) {
                    COSArray sigCerts = new COSArray();
                    for (CertificateToken certificateToken : certificateTokensToAdd) {
                        COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, certificateToken);
                        if (sigCerts.indexOf(cosObject) != -1) continue;
                        sigCerts.add(cosObject);
                        if (certs.indexOf(cosObject) != -1) continue;
                        certs.add(cosObject);
                    }
                    sigVriDictionary.setItem("Cert", (COSBase)sigCerts);
                }
                if (Utils.isCollectionNotEmpty(crlTokensToAdd = validationData.getCrlTokens())) {
                    COSArray sigCrls = new COSArray();
                    for (CRLToken crlToken : crlTokensToAdd) {
                        COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, crlToken);
                        if (sigCrls.indexOf(cosObject) != -1) continue;
                        sigCrls.add(cosObject);
                        if (crls.indexOf(cosObject) != -1) continue;
                        crls.add(cosObject);
                    }
                    sigVriDictionary.setItem("CRL", (COSBase)sigCrls);
                }
                if (Utils.isCollectionNotEmpty(ocspTokensToAdd = validationData.getOcspTokens())) {
                    COSArray cOSArray = new COSArray();
                    for (OCSPToken ocspToken : ocspTokensToAdd) {
                        COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, ocspToken);
                        if (cOSArray.indexOf(cosObject) != -1) continue;
                        cOSArray.add(cosObject);
                        if (ocsps.indexOf(cosObject) != -1) continue;
                        ocsps.add(cosObject);
                    }
                    sigVriDictionary.setItem("OCSP", (COSBase)cOSArray);
                }
                String string = ((PAdESSignature)signature).getVRIKey();
                vriDictionary.setItem(string, (COSBase)sigVriDictionary);
            }
            dss.setItem("VRI", (COSBase)vriDictionary);
        }
        if (Utils.isCollectionNotEmpty(detachedTimestamps = validationDataForInclusion.getDetachedTimestamps())) {
            Set<OCSPToken> set;
            Set<CRLToken> crlTokensToAdd;
            ValidationData validationDataToAdd = validationDataForInclusion.getAllValidationData();
            Set<CertificateToken> certificateTokensToAdd = validationDataToAdd.getCertificateTokens();
            if (Utils.isCollectionNotEmpty(certificateTokensToAdd)) {
                for (CertificateToken certificateToken : certificateTokensToAdd) {
                    COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, certificateToken);
                    if (certs.indexOf(cosObject) != -1) continue;
                    certs.add(cosObject);
                }
            }
            if (Utils.isCollectionNotEmpty(crlTokensToAdd = validationDataToAdd.getCrlTokens())) {
                for (CRLToken crlToken : crlTokensToAdd) {
                    COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, crlToken);
                    if (crls.indexOf(cosObject) != -1) continue;
                    crls.add(cosObject);
                }
            }
            if (Utils.isCollectionNotEmpty(set = validationDataToAdd.getOcspTokens())) {
                for (OCSPToken ocspToken : validationDataToAdd.getOcspTokens()) {
                    COSBase cosObject = this.getPdfObjectForToken(pdDocument, validationDataForInclusion, knownObjects, ocspToken);
                    if (ocsps.indexOf(cosObject) != -1) continue;
                    ocsps.add(cosObject);
                }
            }
        }
        if (certs.size() > 0) {
            dss.setItem("Certs", (COSBase)certs);
        }
        if (crls.size() > 0) {
            dss.setItem("CRLs", (COSBase)crls);
        }
        if (ocsps.size() > 0) {
            dss.setItem("OCSPs", (COSBase)ocsps);
        }
        return dss;
    }

    private COSBase getPdfObjectForToken(PDDocument pdDocument, PdfValidationDataContainer validationDataContainer, Map<String, COSBase> knownObjects, Token token) throws IOException {
        String tokenKey = validationDataContainer.getTokenKey(token);
        COSBase object = knownObjects.get(tokenKey);
        if (object != null) {
            return object;
        }
        Long objectNumber = validationDataContainer.getTokenReference(token);
        if (objectNumber == null) {
            COSStream stream = pdDocument.getDocument().createCOSStream();
            try (OutputStream unfilteredStream = stream.createOutputStream();){
                unfilteredStream.write(token.getEncoded());
                unfilteredStream.flush();
            }
            object = stream;
        } else {
            object = this.getByObjectNumber(pdDocument, objectNumber);
        }
        knownObjects.put(tokenKey, object);
        return object;
    }

    private COSObject getByObjectNumber(PDDocument pdDocument, Long objectNumber) {
        List<COSObject> objects = pdDocument.getDocument().getObjects();
        for (COSObject cosObject : objects) {
            if (cosObject.getObjectNumber() != objectNumber.longValue()) continue;
            return cosObject;
        }
        return null;
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document, String pwd) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = document.openStream();
             PDDocument pdfDoc = PDDocument.load(is, pwd);){
            List<PDSignatureField> signatureFields = pdfDoc.getSignatureFields();
            for (PDSignatureField pdSignatureField : signatureFields) {
                PDSignature signature = pdSignatureField.getSignature();
                if (signature != null) continue;
                result.add(pdSignatureField.getPartialName());
            }
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(e.getMessage());
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to retrieve signature fields. Reason : %s", e.getMessage()), e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, String pwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument previewPageWithVisualSignature(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument previewSignatureField(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DSSDocument getNewSignatureFieldScreenshot(DSSDocument doc, PAdESCommonParameters parameters, List<PdfAnnotation> originalAnnotations) throws IOException {
        try (PdfBoxDocumentReader reader = new PdfBoxDocumentReader(doc, parameters.getPasswordProtection());){
            List<PdfAnnotation> newAnnotations = reader.getPdfAnnotations(parameters.getImageParameters().getFieldParameters().getPage());
            AnnotationBox pageBox = reader.getPageBox(parameters.getImageParameters().getFieldParameters().getPage());
            PdfAnnotation newField = null;
            for (PdfAnnotation newAnnotation : newAnnotations) {
                boolean found = false;
                for (PdfAnnotation originalAnnotation : originalAnnotations) {
                    if (!Utils.areStringsEqual(originalAnnotation.getName(), newAnnotation.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                newField = newAnnotation;
                break;
            }
            if (newField != null) {
                AnnotationBox fieldBox = newField.getAnnotationBox();
                AnnotationBox box = fieldBox.toPdfPageCoordinates(pageBox.getHeight());
                BufferedImage page = reader.generateImageScreenshot(parameters.getImageParameters().getFieldParameters().getPage());
                BufferedImage annotationRepresentation = page.getSubimage(Math.round(box.getMaxX() - box.getWidth()), Math.round(box.getMaxY() - box.getHeight()), Math.round(box.getWidth()), Math.round(box.getHeight()));
                DSSDocument dSSDocument = ImageUtils.toDSSDocument(annotationRepresentation, this.instantiateResourcesHandler());
                return dSSDocument;
            }
            throw new DSSException("Internal error : unable to extract a new signature field!");
        }
    }

    @Override
    protected PdfDocumentReader loadPdfDocumentReader(DSSDocument dssDocument, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        return new PdfBoxDocumentReader(dssDocument, passwordProtection);
    }

    @Override
    protected PdfDocumentReader loadPdfDocumentReader(byte[] binaries, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        return new PdfBoxDocumentReader(binaries, passwordProtection);
    }
}

