/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.modifications.CommonPdfModification;
import eu.europa.esig.dss.pdf.modifications.PdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.PdfModification;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPdfDifferencesFinder
implements PdfDifferencesFinder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPdfDifferencesFinder.class);
    private int maximalPagesAmountForVisualComparison = 10;

    public void setMaximalPagesAmountForVisualComparison(int pagesAmount) {
        this.maximalPagesAmountForVisualComparison = pagesAmount;
    }

    @Override
    public List<PdfModification> getAnnotationOverlaps(PdfDocumentReader reader) {
        ArrayList<PdfModification> annotationOverlaps = new ArrayList<PdfModification>();
        block0: for (int pageNumber = 1; pageNumber <= reader.getNumberOfPages(); ++pageNumber) {
            List<PdfAnnotation> pdfAnnotations = this.getPdfAnnotations(reader, pageNumber);
            Iterator<PdfAnnotation> iterator = pdfAnnotations.iterator();
            while (iterator.hasNext()) {
                PdfAnnotation annotation = iterator.next();
                iterator.remove();
                if (!this.isAnnotationBoxOverlapping(annotation.getAnnotationBox(), pdfAnnotations)) continue;
                annotationOverlaps.add(new CommonPdfModification(pageNumber));
                continue block0;
            }
        }
        return annotationOverlaps;
    }

    private List<PdfAnnotation> getPdfAnnotations(PdfDocumentReader reader, int pageNumber) {
        try {
            return reader.getPdfAnnotations(pageNumber);
        }
        catch (IOException e) {
            LOG.warn("Unable to extract annotations from a PDF document for a page number : {}. Reason : {}", pageNumber, e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isAnnotationBoxOverlapping(AnnotationBox annotationBox, List<PdfAnnotation> pdfAnnotations) {
        if (annotationBox.getWidth() == 0.0f || annotationBox.getHeight() == 0.0f) {
            return false;
        }
        for (PdfAnnotation pdfAnnotation : pdfAnnotations) {
            if (!annotationBox.isOverlap(pdfAnnotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PdfModification> getPagesDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        int signedPages = signedRevisionReader.getNumberOfPages();
        int finalPages = finalRevisionReader.getNumberOfPages();
        int maxNumberOfPages = Math.max(signedPages, finalPages);
        int minNumberOfPages = Math.min(signedPages, finalPages);
        ArrayList<PdfModification> missingPages = new ArrayList<PdfModification>();
        for (int ii = maxNumberOfPages; ii > minNumberOfPages; --ii) {
            missingPages.add(new CommonPdfModification(ii));
        }
        if (Utils.isCollectionNotEmpty(missingPages)) {
            LOG.warn("The provided PDF file contains {} additional pages against the signed revision!", (Object)(maxNumberOfPages - minNumberOfPages));
        }
        return missingPages;
    }

    @Override
    public List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        int pagesAmount = finalRevisionReader.getNumberOfPages();
        if (this.maximalPagesAmountForVisualComparison < pagesAmount) {
            LOG.debug("The provided document contains {} pages, while the limit for a visual comparison is set to {}. Visual differences comparison is skipped.", (Object)pagesAmount, (Object)this.maximalPagesAmountForVisualComparison);
            return Collections.emptyList();
        }
        ArrayList<PdfModification> visualDifferences = new ArrayList<PdfModification>();
        for (int pageNumber = 1; pageNumber <= signedRevisionReader.getNumberOfPages() && pageNumber <= finalRevisionReader.getNumberOfPages(); ++pageNumber) {
            try {
                BufferedImage signedScreenshot = signedRevisionReader.generateImageScreenshot(pageNumber);
                List<PdfAnnotation> signedAnnotations = signedRevisionReader.getPdfAnnotations(pageNumber);
                List<PdfAnnotation> finalAnnotations = finalRevisionReader.getPdfAnnotations(pageNumber);
                List<PdfAnnotation> addedAnnotations = this.getUpdatedAnnotations(signedAnnotations, finalAnnotations);
                BufferedImage finalScreenshot = finalRevisionReader.generateImageScreenshotWithoutAnnotations(pageNumber, addedAnnotations);
                if (ImageUtils.imagesEqual(signedScreenshot, finalScreenshot)) continue;
                LOG.warn("A visual difference found on page {} between a signed revision and the final document!", (Object)pageNumber);
                visualDifferences.add(new CommonPdfModification(pageNumber));
                continue;
            }
            catch (IOException e) {
                LOG.warn("Unable to get visual differences for a page number : {}. Reason : {}", pageNumber, e.getMessage(), e);
            }
        }
        return visualDifferences;
    }

    private List<PdfAnnotation> getUpdatedAnnotations(List<PdfAnnotation> signedAnnotations, List<PdfAnnotation> finalAnnotations) {
        ArrayList<PdfAnnotation> updatesAnnotations = new ArrayList<PdfAnnotation>();
        for (PdfAnnotation annotationBox : finalAnnotations) {
            if (signedAnnotations.contains(annotationBox)) continue;
            updatesAnnotations.add(annotationBox);
        }
        return updatesAnnotations;
    }
}

