/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pdf.modifications.PdfModificationDetection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;

public abstract class PdfCMSRevision
implements PdfRevision {
    private static final long serialVersionUID = 7392943800496129517L;
    private final PdfSignatureDictionary signatureDictionary;
    private final DSSDocument signedContent;
    private final boolean coverAllOriginalBytes;
    private final List<PdfSignatureField> signatureFields;
    private PdfModificationDetection modificationDetection;

    protected PdfCMSRevision(PdfSignatureDictionary signatureDictionary, List<PdfSignatureField> signatureFields, DSSDocument signedContent, boolean coverAllOriginalBytes) {
        Objects.requireNonNull(signatureDictionary, "The signature dictionary cannot be null!");
        Objects.requireNonNull(signatureFields, "The signature fields must be defined!");
        Objects.requireNonNull(signedContent, "The signed content cannot be null!");
        this.signatureDictionary = signatureDictionary;
        this.signatureFields = signatureFields;
        this.signedContent = signedContent;
        this.coverAllOriginalBytes = coverAllOriginalBytes;
    }

    public DSSDocument getSignedData() {
        return this.signedContent;
    }

    @Override
    public PdfSignatureDictionary getPdfSigDictInfo() {
        return this.signatureDictionary;
    }

    public ByteRange getByteRange() {
        return this.signatureDictionary.getByteRange();
    }

    public Date getSigningDate() {
        return this.signatureDictionary.getSigningDate();
    }

    public boolean areAllOriginalBytesCovered() {
        return this.coverAllOriginalBytes;
    }

    @Override
    public List<PdfSignatureField> getFields() {
        return this.signatureFields;
    }

    public CMSSignedData getCMSSignedData() {
        return this.signatureDictionary.getCMSSignedData();
    }

    @Override
    public PdfModificationDetection getModificationDetection() {
        return this.modificationDetection;
    }

    public void setModificationDetection(PdfModificationDetection modificationDetection) {
        this.modificationDetection = modificationDetection;
    }
}

