/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCompositeDssDictOCSPSource
extends OfflineOCSPSource {
    private final Map<Long, Set<OCSPResponseBinary>> ocspBinaryByIdMap = new HashMap<Long, Set<OCSPResponseBinary>>();
    private final Map<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<Long>> ocspBinaryByObjectMap = new HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<Long>>();
    private final Map<RevocationToken<OCSP>, Set<Long>> ocspTokenMap = new HashMap<RevocationToken<OCSP>, Set<Long>>();

    public void populateFromDssDictionary(PdfDssDict dssDictionary) {
        this.extractDSSOCSPs(dssDictionary);
        this.extractVRIOCSPs(dssDictionary);
    }

    protected void extractDSSOCSPs(PdfDssDict dssDictionary) {
        Map<Long, OCSPResponseBinary> dssOCSPMap = dssDictionary.getOCSPs();
        this.populateObjectsMap(dssOCSPMap);
        for (OCSPResponseBinary OCSP2 : dssOCSPMap.values()) {
            this.addBinary(OCSP2, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRIOCSPs(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            List<PdfVRIDict> vriDictList = dssDictionary.getVRIs();
            for (PdfVRIDict vriDict : vriDictList) {
                this.populateObjectsMap(vriDict.getOCSPs());
                this.extractVRIOCSPs(vriDict);
            }
        }
    }

    private void populateObjectsMap(Map<Long, OCSPResponseBinary> ocspMap) {
        for (Map.Entry<Long, OCSPResponseBinary> entry : ocspMap.entrySet()) {
            this.populateMapById(entry.getKey(), entry.getValue());
            this.populateMapByObject(entry.getKey(), entry.getValue());
        }
    }

    private void populateMapById(Long objectId, OCSPResponseBinary ocspBinary) {
        Set<OCSPResponseBinary> ocspBinaries = this.ocspBinaryByIdMap.get(objectId);
        if (ocspBinaries == null) {
            ocspBinaries = new HashSet<OCSPResponseBinary>();
        }
        ocspBinaries.add(ocspBinary);
        this.ocspBinaryByIdMap.put(objectId, ocspBinaries);
    }

    private void populateMapByObject(Long objectId, OCSPResponseBinary ocspBinary) {
        Set<Long> objectIds = this.ocspBinaryByObjectMap.get(ocspBinary);
        if (objectIds == null) {
            objectIds = new HashSet<Long>();
        }
        objectIds.add(objectId);
        this.ocspBinaryByObjectMap.put(ocspBinary, objectIds);
    }

    protected void extractVRIOCSPs(PdfVRIDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<Long, OCSPResponseBinary> OCSPEntry : vriDictionary.getOCSPs().entrySet()) {
                this.addBinary(OCSPEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }

    protected Set<OCSPResponseBinary> getOCSPBinariesByObjectId(Long objectId) {
        return this.ocspBinaryByIdMap.get(objectId);
    }

    protected Set<Long> getRevocationTokenIds(RevocationToken<OCSP> ocspToken) {
        return this.ocspTokenMap.get(ocspToken);
    }

    @Override
    public void addRevocation(RevocationToken<OCSP> token, EncapsulatedRevocationTokenIdentifier<OCSP> binary) {
        super.addRevocation(token, binary);
        Set<Long> tokenBinaryObjectIds = this.getTokenBinaryObjectIds(binary);
        this.ocspTokenMap.put(token, tokenBinaryObjectIds);
    }

    protected Set<Long> getTokenBinaryObjectIds(EncapsulatedRevocationTokenIdentifier<OCSP> binary) {
        return this.ocspBinaryByObjectMap.get(binary);
    }
}

