/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.ImageScaling;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class SignatureImageParameters
implements Serializable {
    private static final long serialVersionUID = -327971057134928889L;
    private static final int NO_SCALING = 100;
    private DSSDocument image;
    private SignatureFieldParameters fieldParameters;
    private int zoom = 100;
    private Color backgroundColor;
    private Integer dpi;
    private VisualSignatureRotation rotation;
    private VisualSignatureAlignmentHorizontal alignmentHorizontal = VisualSignatureAlignmentHorizontal.NONE;
    private VisualSignatureAlignmentVertical alignmentVertical = VisualSignatureAlignmentVertical.NONE;
    private ImageScaling imageScaling = ImageScaling.STRETCH;
    private SignatureImageTextParameters textParameters;

    public DSSDocument getImage() {
        return this.image;
    }

    public void setImage(DSSDocument image) {
        this.image = image;
    }

    public SignatureFieldParameters getFieldParameters() {
        if (this.fieldParameters == null) {
            this.fieldParameters = new SignatureFieldParameters();
        }
        return this.fieldParameters;
    }

    public void setFieldParameters(SignatureFieldParameters fieldParameters) {
        this.fieldParameters = fieldParameters;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Integer getDpi() {
        return DPIUtils.getDpi(this.dpi);
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public SignatureImageTextParameters getTextParameters() {
        if (this.textParameters == null) {
            this.textParameters = new SignatureImageTextParameters();
        }
        return this.textParameters;
    }

    public void setTextParameters(SignatureImageTextParameters textParameters) {
        this.textParameters = textParameters;
    }

    public VisualSignatureRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(VisualSignatureRotation rotation) {
        this.rotation = rotation;
    }

    public VisualSignatureAlignmentHorizontal getVisualSignatureAlignmentHorizontal() {
        return this.alignmentHorizontal;
    }

    public void setAlignmentHorizontal(VisualSignatureAlignmentHorizontal alignmentHorizontal) {
        this.alignmentHorizontal = alignmentHorizontal;
    }

    public VisualSignatureAlignmentVertical getVisualSignatureAlignmentVertical() {
        return this.alignmentVertical;
    }

    public void setAlignmentVertical(VisualSignatureAlignmentVertical alignmentVertical) {
        this.alignmentVertical = alignmentVertical;
    }

    public ImageScaling getImageScaling() {
        return this.imageScaling;
    }

    public void setImageScaling(ImageScaling imageScaling) {
        Objects.requireNonNull(imageScaling, "ImageScaling parameter cannot be null!");
        this.imageScaling = imageScaling;
    }

    public boolean isEmpty() {
        return this.image == null && this.getTextParameters().isEmpty();
    }

    public String toString() {
        return "SignatureImageParameters [image=" + this.image + ", zoom=" + this.zoom + ", backgroundColor=" + this.backgroundColor + ", dpi=" + this.dpi + ", rotation=" + (Object)((Object)this.rotation) + ", alignmentHorizontal=" + (Object)((Object)this.alignmentHorizontal) + ", alignmentVertical=" + (Object)((Object)this.alignmentVertical) + ", fieldParameters=" + this.getFieldParameters() + ", textParameters=" + this.getTextParameters() + "]";
    }
}

