/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InMemoryDocument
extends CommonDocument {
    private byte[] bytes;

    public InMemoryDocument() {
    }

    public InMemoryDocument(byte[] bytes) {
        this(bytes, null, null);
    }

    public InMemoryDocument(byte[] bytes, String name) {
        this(bytes, name, MimeType.fromFileName(name));
    }

    public InMemoryDocument(byte[] bytes, String name, MimeType mimeType) {
        Objects.requireNonNull(bytes, "Bytes cannot be null");
        this.bytes = bytes;
        this.name = name;
        this.mimeType = mimeType;
    }

    public InMemoryDocument(InputStream inputStream) {
        this(InMemoryDocument.toByteArray(inputStream), null, null);
    }

    public InMemoryDocument(InputStream inputStream, String name) {
        this(InMemoryDocument.toByteArray(inputStream), name);
    }

    public InMemoryDocument(InputStream inputStream, String name, MimeType mimeType) {
        this(InMemoryDocument.toByteArray(inputStream), name, mimeType);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] toByteArray(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream is null");
        try (InputStream is = inputStream;){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[2048];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, nRead);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new DSSException("Unable to fully read the InputStream", e);
        }
    }

    @Override
    public InputStream openStream() {
        Objects.requireNonNull(this.bytes, "Byte array is not defined!");
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getBase64Encoded() {
        Objects.requireNonNull(this.bytes, "Byte array is not defined!");
        return Base64.getEncoder().encodeToString(this.bytes);
    }
}

