/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.parsers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateParser {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private DateParser() {
    }

    public static Date parse(String v) {
        if (v == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sdf.setTimeZone(UTC);
            sdf.setLenient(false);
            return sdf.parse(v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("String '%s' doesn't follow the pattern '%s'", v, DATE_FORMAT));
        }
    }

    public static String print(Date v) {
        if (v != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sdf.setTimeZone(UTC);
            return sdf.format(v);
        }
        return null;
    }
}

