/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.alert.AbstractAlert;
import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.alert.handler.AlertHandler;
import eu.europa.esig.dss.jaxb.common.DSSErrorHandler;
import eu.europa.esig.dss.jaxb.common.exception.XSDValidationException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class DSSErrorHandlerAlert
extends AbstractAlert<DSSErrorHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(DSSErrorHandlerAlert.class);
    private static final String ERROR_MESSAGE = "Error during the XML schema validation : {}";

    public DSSErrorHandlerAlert() {
        super(new DSSErrorHandlerAlertDetector(), new DSSErrorHandlerAlertHandler());
    }

    private static final class DSSErrorHandlerAlertDetector
    implements AlertDetector<DSSErrorHandler> {
        private DSSErrorHandlerAlertDetector() {
        }

        @Override
        public boolean detect(DSSErrorHandler errorHandler) {
            return !errorHandler.isValid();
        }
    }

    private static final class DSSErrorHandlerAlertHandler
    implements AlertHandler<DSSErrorHandler> {
        private DSSErrorHandlerAlertHandler() {
        }

        @Override
        public void process(DSSErrorHandler errorHandler) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.addAll(this.processErrors(errorHandler.getErrors()));
            errors.addAll(this.processFatalErrors(errorHandler.getFatalErrors()));
            this.processWarnings(errorHandler.getWarnings());
            throw new XSDValidationException(errors);
        }

        private List<String> processErrors(List<SAXException> exceptions) {
            ArrayList<String> messages = new ArrayList<String>();
            for (SAXException exception : exceptions) {
                LOG.warn(DSSErrorHandlerAlert.ERROR_MESSAGE, (Object)exception.getMessage());
                messages.add(exception.getMessage());
            }
            return messages;
        }

        private List<String> processFatalErrors(List<SAXException> exceptions) {
            ArrayList<String> messages = new ArrayList<String>();
            for (SAXException exception : exceptions) {
                LOG.error(DSSErrorHandlerAlert.ERROR_MESSAGE, (Object)exception.getMessage());
                messages.add(exception.getMessage());
            }
            return messages;
        }

        private List<String> processWarnings(List<SAXException> exceptions) {
            ArrayList<String> messages = new ArrayList<String>();
            for (SAXException exception : exceptions) {
                LOG.debug(DSSErrorHandlerAlert.ERROR_MESSAGE, (Object)exception.getMessage());
                messages.add(exception.getMessage());
            }
            return messages;
        }
    }
}

