/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public abstract class AbstractJaxbFacade<T> {
    protected AbstractJaxbFacade() {
    }

    protected abstract JAXBContext getJAXBContext() throws JAXBException;

    protected abstract Schema getSchema() throws IOException, SAXException;

    protected abstract JAXBElement<T> wrap(T var1);

    public String marshall(T jaxbObject) throws JAXBException, IOException, SAXException {
        return this.marshall(jaxbObject, true);
    }

    public String marshall(T jaxbObject, boolean validate) throws JAXBException, IOException, SAXException {
        Objects.requireNonNull(jaxbObject, "JAXBObject is null");
        Marshaller marshaller = this.getMarshaller(validate);
        try (StringWriter writer = new StringWriter();){
            marshaller.marshal(this.wrap(jaxbObject), writer);
            String string = writer.toString();
            return string;
        }
    }

    public void marshall(T jaxbObject, OutputStream os) throws JAXBException, SAXException, IOException {
        this.marshall(jaxbObject, os, true);
    }

    public void marshall(T jaxbObject, OutputStream os, boolean validate) throws JAXBException, SAXException, IOException {
        Objects.requireNonNull(jaxbObject, "JAXBObject is null");
        Objects.requireNonNull(os, "OutputStream is null");
        Marshaller marshaller = this.getMarshaller(validate);
        marshaller.marshal(this.wrap(jaxbObject), os);
    }

    public T unmarshall(InputStream is) throws JAXBException, XMLStreamException, IOException, SAXException {
        return this.unmarshall(is, true);
    }

    public T unmarshall(InputStream is, boolean validate) throws JAXBException, XMLStreamException, IOException, SAXException {
        Objects.requireNonNull(is, "InputStream is null");
        return this.unmarshall(new StreamSource(is), validate);
    }

    public T unmarshall(File file) throws JAXBException, XMLStreamException, IOException, SAXException {
        return this.unmarshall(file, true);
    }

    public T unmarshall(File file, boolean validate) throws JAXBException, XMLStreamException, IOException, SAXException {
        Objects.requireNonNull(file, "File is null");
        return this.unmarshall(new StreamSource(file), validate);
    }

    public T unmarshall(String xmlObject) throws JAXBException, XMLStreamException, IOException, SAXException {
        return this.unmarshall(xmlObject, true);
    }

    public T unmarshall(String xmlObject, boolean validate) throws JAXBException, XMLStreamException, IOException, SAXException {
        Objects.requireNonNull(xmlObject, "xmlObject is null");
        return this.unmarshall(new StreamSource(new StringReader(xmlObject)), validate);
    }

    private T unmarshall(Source source, boolean validate) throws JAXBException, XMLStreamException, IOException, SAXException {
        Unmarshaller unmarshaller = this.getUnmarshaller(validate);
        JAXBElement unmarshal = (JAXBElement)unmarshaller.unmarshal(this.avoidXXE(source));
        return unmarshal.getValue();
    }

    public Marshaller getMarshaller(boolean validate) throws JAXBException, SAXException, IOException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        if (validate) {
            marshaller.setSchema(this.getSchema());
        }
        marshaller.setProperty("jaxb.formatted.output", true);
        return marshaller;
    }

    public Unmarshaller getUnmarshaller(boolean validate) throws JAXBException, IOException, SAXException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        if (validate) {
            unmarshaller.setSchema(this.getSchema());
        }
        return unmarshaller;
    }

    private XMLStreamReader avoidXXE(Source source) throws XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        return xif.createXMLStreamReader(source);
    }
}

