/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation.timestamp;

import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jose4j.json.internal.json_simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESTimestampDataBuilder
implements TimestampDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESTimestampDataBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken with Id '{}'. Reason : {}";
    private final JAdESSignature signature;

    public JAdESTimestampDataBuilder(JAdESSignature signature) {
        this.signature = signature;
    }

    @Override
    public DSSDocument getContentTimestampData(TimestampToken timestampToken) {
        try {
            byte[] signedDataBinaries = this.getSignedDataBinaries();
            return new InMemoryDocument(signedDataBinaries);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    private byte[] getSignedDataBinaries() {
        SigDMechanism sigDMechanism = this.signature.getSigDMechanism();
        if (sigDMechanism != null) {
            return this.getSigDReferencedOctets(sigDMechanism);
        }
        return this.getJWSPayloadValue();
    }

    private byte[] getJWSPayloadValue() {
        byte[] payload = this.signature.getJws().isRfc7797UnencodedPayload() ? this.signature.getJws().getUnverifiedPayloadBytes() : this.signature.getJws().getEncodedPayload().getBytes();
        if (Utils.isArrayEmpty(payload)) {
            throw new DSSException("Unable to extract JWS payload!");
        }
        return payload;
    }

    private byte[] getSigDReferencedOctets(SigDMechanism sigDMechanism) {
        byte[] sigDOctets = null;
        switch (sigDMechanism) {
            case HTTP_HEADERS: {
                List<DSSDocument> documentList = this.signature.getSignedDocumentsByHTTPHeaderName();
                HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(documentList, true);
                sigDOctets = httpHeadersPayloadBuilder.build();
                break;
            }
            case OBJECT_ID_BY_URI: 
            case OBJECT_ID_BY_URI_HASH: {
                List<DSSDocument> documentList = this.signature.getSignedDocumentsForObjectIdByUriMechanism();
                sigDOctets = DSSJsonUtils.concatenateDSSDocuments(documentList, !this.signature.getJws().isRfc7797UnencodedPayload());
                break;
            }
            default: {
                LOG.warn("Unsupported SigDMechanism '{}' has been found!", (Object)sigDMechanism);
            }
        }
        return sigDOctets;
    }

    @Override
    public DSSDocument getSignatureTimestampData(TimestampToken timestampToken) {
        try {
            byte[] signatureTimestampData = this.getSignatureTimestampData();
            return new InMemoryDocument(signatureTimestampData);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getSignatureTimestampData() {
        return this.getBase64UrlEncodedSignatureValue();
    }

    @Override
    public DSSDocument getTimestampX1Data(TimestampToken timestampToken) {
        try {
            byte[] timestampX1Data = this.getTimestampX1Data(timestampToken, null);
            return new InMemoryDocument(timestampX1Data);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    protected byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get '{}' timestamp data", (Object)"sigRTst");
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        JWS jws = this.signature.getJws();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(this.getBase64UrlEncodedSignatureValue());
            baos.write(46);
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (timestampToken == null || !timestampToken.getTimestampAttribute().equals(etsiUComponent)) {
                        if (!this.isAllowedTypeEntry(etsiUComponent, "sigTst", "xRefs", "rRefs", "axRefs", "arRefs")) continue;
                        baos.write(this.getEtsiUComponentValue(etsiUComponent, canonicalizationMethod));
                        continue;
                    }
                    break;
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for a '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"sigRTst");
            }
            byte[] messageImprint = baos.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("The '{}' timestamp message-imprint : {}", (Object)"sigRTst", (Object)new String(messageImprint));
            }
            object = messageImprint;
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building a message-imprint for '%s'! Reason : %s", "sigRTst", e.getMessage()), e);
            }
        }
        baos.close();
        return object;
    }

    private boolean isAllowedTypeEntry(EtsiUComponent etsiUComponent, String ... allowedTypes) {
        return Arrays.stream(allowedTypes).anyMatch(etsiUComponent.getHeaderName()::equals);
    }

    @Override
    public DSSDocument getTimestampX2Data(TimestampToken timestampToken) {
        try {
            byte[] timestampX2Data = this.getTimestampX2Data(timestampToken, null);
            return new InMemoryDocument(timestampX2Data);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    protected byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get '{}' timestamp data", (Object)"rfsTst");
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        JWS jws = this.signature.getJws();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (!this.isAllowedTypeEntry(etsiUComponent, "xRefs", "rRefs", "axRefs", "arRefs")) continue;
                    baos.write(this.getEtsiUComponentValue(etsiUComponent, canonicalizationMethod));
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for an '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"rfsTst");
            }
            byte[] messageImprint = baos.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("The '{}' timestamp message-imprint : {}", (Object)"rfsTst", (Object)new String(messageImprint));
            }
            object = messageImprint;
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building a message-imprint for '%s'! Reason : %s", "rfsTst", e.getMessage()), e);
            }
        }
        baos.close();
        return object;
    }

    @Override
    public DSSDocument getArchiveTimestampData(TimestampToken timestampToken) {
        try {
            byte[] archiveTimestampData = this.getArchiveTimestampData(timestampToken, null);
            return new InMemoryDocument(archiveTimestampData);
        }
        catch (DSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.getArchiveTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get '{}' timestamp data : {}", (Object)"arcTst", (Object)(timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        JWS jws = this.signature.getJws();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(this.getSignedDataBinaries());
            baos.write(46);
            baos.write(jws.getEncodedHeader().getBytes());
            baos.write(46);
            baos.write(this.getBase64UrlEncodedSignatureValue());
            baos.write(46);
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (timestampToken == null || !timestampToken.getTimestampAttribute().equals(etsiUComponent)) {
                        baos.write(this.getEtsiUComponentValue(etsiUComponent, canonicalizationMethod));
                        continue;
                    }
                    break;
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for an '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"arcTst");
            }
            byte[] messageImprint = baos.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("The '{}' timestamp message-imprint : {}", (Object)"arcTst", (Object)new String(messageImprint));
            }
            object = messageImprint;
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException(String.format("An error occurred while building a message-imprint for '%s'! Reason : %s", "arcTst", e.getMessage()), e);
            }
        }
        baos.close();
        return object;
    }

    private byte[] getBase64UrlEncodedSignatureValue() {
        String messageImprint = this.signature.getJws().getEncodedSignature();
        if (LOG.isTraceEnabled()) {
            LOG.trace("The '{}' timestamp message-imprint : {}", (Object)"sigTst", (Object)messageImprint);
        }
        return messageImprint.getBytes();
    }

    private byte[] getEtsiUComponentValue(EtsiUComponent etsiUComponent, String canonicalizationMethod) {
        Object component = etsiUComponent.getComponent();
        if (etsiUComponent.isBase64UrlEncoded()) {
            return ((String)component).getBytes();
        }
        return this.getCanonicalizedValue(etsiUComponent.getValue(), canonicalizationMethod);
    }

    private byte[] getCanonicalizedValue(Object jsonObject, String canonicalizationMethod) {
        LOG.warn("Canonicalization is not supported in the current version. The message imprint computation can lead to an unexpected result");
        String jsonString = JSONValue.toJSONString(jsonObject);
        return jsonString.getBytes();
    }
}

