/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.scope.JAdESSignatureScopeFinder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.NonASN1SignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJWSDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJWSDocumentValidator.class);
    private JWSJsonSerializationObject jwsJsonSerializationObject;

    protected AbstractJWSDocumentValidator() {
    }

    protected AbstractJWSDocumentValidator(DSSDocument document) {
        super(new JAdESSignatureScopeFinder());
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
        this.jwsJsonSerializationObject = this.buildJwsJsonSerializationObject();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        JAdESSignature jadesSignature = (JAdESSignature)advancedSignature;
        try {
            return jadesSignature.getOriginalDocuments();
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }

    public JWSJsonSerializationObject getJwsJsonSerializationObject() {
        return this.jwsJsonSerializationObject;
    }

    protected abstract JWSJsonSerializationObject buildJwsJsonSerializationObject();

    @Override
    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        DefaultSignaturePolicyValidatorLoader signaturePolicyValidatorLoader = new DefaultSignaturePolicyValidatorLoader();
        signaturePolicyValidatorLoader.setDefaultSignaturePolicyValidator(new NonASN1SignaturePolicyValidator());
        return signaturePolicyValidatorLoader;
    }
}

