/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.signature.AbstractJAdESBuilder;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class JAdESSerializationBuilder
extends AbstractJAdESBuilder {
    private JWSJsonSerializationObject jwsJsonSerializationObject;

    public JAdESSerializationBuilder(CertificateVerifier certificateVerifier, JAdESSignatureParameters parameters, List<DSSDocument> documentsToSign) {
        super(certificateVerifier, parameters, documentsToSign);
    }

    public JAdESSerializationBuilder(CertificateVerifier certificateVerifier, JAdESSignatureParameters parameters, JWSJsonSerializationObject jwsJsonSerializationObject) {
        super(certificateVerifier, parameters, JAdESSerializationBuilder.extractDocumentToBeSigned(parameters, jwsJsonSerializationObject));
        this.jwsJsonSerializationObject = jwsJsonSerializationObject;
    }

    private static List<DSSDocument> extractDocumentToBeSigned(JAdESSignatureParameters parameters, JWSJsonSerializationObject jwsJsonSerializationObject) {
        if (Utils.isStringNotBlank(jwsJsonSerializationObject.getPayload())) {
            JWS jws = jwsJsonSerializationObject.getSignatures().get(0);
            byte[] payloadBytes = jws.isRfc7797UnencodedPayload() ? jwsJsonSerializationObject.getPayload().getBytes(StandardCharsets.UTF_8) : DSSJsonUtils.fromBase64Url(jwsJsonSerializationObject.getPayload());
            return Collections.singletonList(new InMemoryDocument(payloadBytes));
        }
        if (Utils.isCollectionNotEmpty(parameters.getDetachedContents())) {
            return parameters.getDetachedContents();
        }
        throw new IllegalArgumentException("The payload or detached content must be provided!");
    }

    @Override
    public DSSDocument build(SignatureValue signatureValue) {
        this.assertConfigurationValidity(this.parameters);
        JWS jws = this.getJWS();
        if (this.jwsJsonSerializationObject == null) {
            this.jwsJsonSerializationObject = new JWSJsonSerializationObject();
            if (!SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging())) {
                this.jwsJsonSerializationObject.setPayload(jws.getSignedPayload());
            }
        } else {
            this.assertB64ConfigurationConsistent();
        }
        byte[] signatureValueBytes = DSSASN1Utils.ensurePlainSignatureValue(this.parameters.getEncryptionAlgorithm(), signatureValue.getValue());
        jws.setSignature(signatureValueBytes);
        this.jwsJsonSerializationObject.getSignatures().add(jws);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(this.jwsJsonSerializationObject, this.parameters.getJwsSerializationType());
        return generator.generate();
    }

    private void assertB64ConfigurationConsistent() {
        if (!SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging())) {
            boolean base64UrlEncodedPayload = this.parameters.isBase64UrlEncodedPayload();
            for (JWS jws : this.jwsJsonSerializationObject.getSignatures()) {
                if (base64UrlEncodedPayload == !jws.isRfc7797UnencodedPayload()) continue;
                throw new IllegalArgumentException("'b64' value shall be the same for all signatures! Change 'Base64UrlEncodedPayload' signature parameter or sign another file!");
            }
        }
    }

    private JWS getJWS() {
        JWS jws = new JWS();
        this.incorporateHeader(jws);
        this.incorporatePayload(jws);
        return jws;
    }

    @Override
    public MimeType getMimeType() {
        return MimeType.JOSE_JSON;
    }

    @Override
    protected void assertConfigurationValidity(JAdESSignatureParameters signatureParameters) {
        SignaturePackaging packaging = signatureParameters.getSignaturePackaging();
        if (packaging != SignaturePackaging.ENVELOPING && packaging != SignaturePackaging.DETACHED) {
            throw new IllegalArgumentException("Unsupported signature packaging for JSON Serialization Signature: " + (Object)((Object)packaging));
        }
        if (!JWSSerializationType.JSON_SERIALIZATION.equals((Object)signatureParameters.getJwsSerializationType()) && this.jwsJsonSerializationObject != null) {
            throw new IllegalArgumentException(String.format("The '%s' type is not supported for a parallel signing!", new Object[]{signatureParameters.getJwsSerializationType()}));
        }
    }
}

