/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineT;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import java.util.List;
import java.util.Set;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONObject;

public class JAdESLevelBaselineLT
extends JAdESLevelBaselineT {
    public JAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        super.extendSignatures(signatures, params);
        boolean ltLevelRequired = false;
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            if (!this.ltLevelExtensionRequired(jadesSignature, params)) continue;
            this.checkSignatureIntegrity(jadesSignature);
            jadesSignature.resetCertificateSource();
            jadesSignature.resetRevocationSources();
            jadesSignature.resetTimestampSource();
            ltLevelRequired = true;
        }
        if (!ltLevelRequired) {
            return;
        }
        ValidationDataContainer validationDataContainer = this.documentValidator.getValidationData(signatures);
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            if (!this.ltLevelExtensionRequired(jadesSignature, params)) continue;
            this.assertExtendSignatureToLTPossible(jadesSignature, params);
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            this.removeOldCertificateValues(jadesSignature, etsiUHeader);
            this.removeOldRevocationValues(jadesSignature, etsiUHeader);
            ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
            Set<CertificateToken> certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set<CRLToken> crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set<OCSPToken> ocspsToAdd = validationDataForInclusion.getOcspTokens();
            this.incorporateXVals(etsiUHeader, certificateValuesToAdd, params.isBase64UrlEncodedEtsiUComponents());
            this.incorporateRVals(etsiUHeader, crlsToAdd, ocspsToAdd, params.isBase64UrlEncodedEtsiUComponents());
        }
    }

    private void removeOldCertificateValues(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        etsiUHeader.removeComponent("xVals");
        jadesSignature.resetCertificateSource();
    }

    private void removeOldRevocationValues(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        etsiUHeader.removeComponent("rVals");
        jadesSignature.resetRevocationSources();
    }

    protected JSONArray getXVals(Set<CertificateToken> certificateValuesToAdd) {
        JSONArray xValsArray = new JSONArray();
        for (CertificateToken certificateToken : certificateValuesToAdd) {
            xValsArray.add(this.getX509CertObject(certificateToken));
        }
        return xValsArray;
    }

    private JSONObject getX509CertObject(CertificateToken certificateToken) {
        JSONObject pkiOb = new JSONObject();
        pkiOb.put("val", Utils.toBase64(certificateToken.getEncoded()));
        JSONObject x509Cert = new JSONObject();
        x509Cert.put("x509Cert", pkiOb);
        return x509Cert;
    }

    protected void incorporateXVals(JAdESEtsiUHeader etsiUHeader, Set<CertificateToken> certificateValuesToAdd, boolean base64UrlEncoded) {
        if (Utils.isCollectionNotEmpty(certificateValuesToAdd)) {
            JSONArray xVals = this.getXVals(certificateValuesToAdd);
            etsiUHeader.addComponent("xVals", xVals, base64UrlEncoded);
        }
    }

    protected JsonObject getRVals(Set<CRLToken> crlsToAdd, Set<OCSPToken> ocspsToAdd) {
        JsonObject rValsObject = new JsonObject();
        if (Utils.isCollectionNotEmpty(crlsToAdd)) {
            rValsObject.put("crlVals", (Object)this.getCrlVals(crlsToAdd));
        }
        if (Utils.isCollectionNotEmpty(ocspsToAdd)) {
            rValsObject.put("ocspVals", (Object)this.getOcspVals(ocspsToAdd));
        }
        return rValsObject;
    }

    private JSONArray getCrlVals(Set<CRLToken> crlsToAdd) {
        JSONArray array = new JSONArray();
        for (CRLToken crlToken : crlsToAdd) {
            JSONObject pkiOb = new JSONObject();
            pkiOb.put("val", Utils.toBase64(crlToken.getEncoded()));
            array.add(pkiOb);
        }
        return array;
    }

    private JSONArray getOcspVals(Set<OCSPToken> ocspsToAdd) {
        JSONArray array = new JSONArray();
        for (OCSPToken ocspToken : ocspsToAdd) {
            JSONObject pkiOb = new JSONObject();
            pkiOb.put("val", Utils.toBase64(ocspToken.getEncoded()));
            array.add(pkiOb);
        }
        return array;
    }

    protected void incorporateRVals(JAdESEtsiUHeader etsiUHeader, Set<CRLToken> crlsToAdd, Set<OCSPToken> ocspsToAdd, boolean base64UrlEncoded) {
        if (Utils.isCollectionNotEmpty(crlsToAdd) || Utils.isCollectionNotEmpty(ocspsToAdd)) {
            JsonObject rVals = this.getRVals(crlsToAdd, ocspsToAdd);
            etsiUHeader.addComponent("rVals", rVals, base64UrlEncoded);
        }
    }

    protected void checkSignatureIntegrity(JAdESSignature jadesSignature) throws DSSException {
        SignatureCryptographicVerification signatureCryptographicVerification = jadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    private boolean ltLevelExtensionRequired(JAdESSignature jadesSignature, JAdESSignatureParameters parameters) {
        return SignatureLevel.JAdES_BASELINE_LT.equals((Object)parameters.getSignatureLevel()) || !jadesSignature.hasLTAProfile();
    }

    private void assertExtendSignatureToLTPossible(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        SignatureLevel signatureLevel = params.getSignatureLevel();
        if (SignatureLevel.JAdES_BASELINE_LT.equals((Object)signatureLevel) && jadesSignature.hasLTAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LTA level.", new Object[]{signatureLevel}));
        }
        if (jadesSignature.areAllSelfSignedCertificates()) {
            throw new IllegalInputException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

