/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import java.util.Objects;

public class JAdESSignatureParameters
extends AbstractSignatureParameters<JAdESTimestampParameters> {
    private static final long serialVersionUID = -5937995983705731252L;
    private boolean includeCertificateChain = true;
    private boolean includeSignatureType = true;
    private boolean includeKeyIdentifier = true;
    private boolean base64UrlEncodedPayload = true;
    private boolean base64UrlEncodedEtsiUComponents = true;
    private DigestAlgorithm signingCertificateDigestMethod = DigestAlgorithm.SHA256;
    private JWSSerializationType jwsSerializationType = JWSSerializationType.COMPACT_SERIALIZATION;
    private SigDMechanism sigDMechanism;

    @Override
    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.JAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only JAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    @Override
    public JAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.contentTimestampParameters;
    }

    @Override
    public JAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.signatureTimestampParameters;
    }

    @Override
    public JAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.archiveTimestampParameters;
    }

    public boolean isIncludeCertificateChain() {
        return this.includeCertificateChain;
    }

    public void setIncludeCertificateChain(boolean includeCertificateChain) {
        this.includeCertificateChain = includeCertificateChain;
    }

    public boolean isIncludeSignatureType() {
        return this.includeSignatureType;
    }

    public void setIncludeSignatureType(boolean includeSignatureType) {
        this.includeSignatureType = includeSignatureType;
    }

    public boolean isIncludeKeyIdentifier() {
        return this.includeKeyIdentifier;
    }

    public void setIncludeKeyIdentifier(boolean includeKeyIdentifier) {
        this.includeKeyIdentifier = includeKeyIdentifier;
    }

    public DigestAlgorithm getSigningCertificateDigestMethod() {
        return this.signingCertificateDigestMethod;
    }

    public void setSigningCertificateDigestMethod(DigestAlgorithm signingCertificateDigestMethod) {
        Objects.requireNonNull(signingCertificateDigestMethod, "SigningCertificateDigestMethod cannot be null!");
        this.signingCertificateDigestMethod = signingCertificateDigestMethod;
    }

    public JWSSerializationType getJwsSerializationType() {
        return this.jwsSerializationType;
    }

    public void setJwsSerializationType(JWSSerializationType jwsSerializationType) {
        Objects.requireNonNull(jwsSerializationType, "JWSSerializationType cannot be null!");
        this.jwsSerializationType = jwsSerializationType;
    }

    public SigDMechanism getSigDMechanism() {
        return this.sigDMechanism;
    }

    public void setSigDMechanism(SigDMechanism sigDMechanism) {
        this.sigDMechanism = sigDMechanism;
    }

    public boolean isBase64UrlEncodedPayload() {
        return this.base64UrlEncodedPayload;
    }

    public void setBase64UrlEncodedPayload(boolean base64EncodedPayload) {
        this.base64UrlEncodedPayload = base64EncodedPayload;
    }

    public boolean isBase64UrlEncodedEtsiUComponents() {
        return this.base64UrlEncodedEtsiUComponents;
    }

    public void setBase64UrlEncodedEtsiUComponents(boolean base64UrlEncodedEtsiUComponents) {
        this.base64UrlEncodedEtsiUComponents = base64UrlEncodedEtsiUComponents;
    }
}

