/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BinaryFilteringInputStream
extends FilterInputStream {
    private boolean on = true;
    private final OutputStream os;

    public BinaryFilteringInputStream(InputStream in, OutputStream os) {
        super(in);
        this.os = os;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (this.on && ch != -1) {
            this.os.write((byte)ch);
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (this.on && result != -1) {
            this.os.write(b, off, result);
        }
        return result;
    }

    public void on(boolean on) {
        this.on = on;
    }
}

