/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignedAssertion;
import eu.europa.esig.dss.cades.SignedAssertions;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.model.CommitmentQualifier;
import eu.europa.esig.dss.model.CommonCommitmentType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.CommitmentTypeQualifier;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.UserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineB.class);
    private final boolean padesUsage;
    private final DSSDocument documentToSign;

    public CAdESLevelBaselineB() {
        this(false);
    }

    public CAdESLevelBaselineB(boolean padesUsage) {
        this(null, padesUsage);
    }

    public CAdESLevelBaselineB(DSSDocument documentToSign) {
        this(documentToSign, false);
    }

    CAdESLevelBaselineB(DSSDocument documentToSign, boolean padesUsage) {
        this.documentToSign = documentToSign;
        this.padesUsage = padesUsage;
    }

    public AttributeTable getUnsignedAttributes() {
        return new AttributeTable(new Hashtable());
    }

    public AttributeTable getSignedAttributes(CAdESSignatureParameters parameters) {
        if (Utils.isArrayNotEmpty(parameters.getSignedData())) {
            LOG.debug("Using explicit SignedAttributes from parameter");
            return CMSUtils.getAttributesFromByteArray(parameters.getSignedData());
        }
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        this.addSigningCertificateAttribute(parameters, signedAttributes);
        this.addSigningTimeAttribute(parameters, signedAttributes);
        this.addSignerAttribute(parameters, signedAttributes);
        this.addSignaturePolicyId(parameters, signedAttributes);
        this.addContentHints(parameters, signedAttributes);
        this.addMimeType(parameters, signedAttributes);
        this.addContentIdentifier(parameters, signedAttributes);
        this.addCommitmentType(parameters, signedAttributes);
        this.addSignerLocation(parameters, signedAttributes);
        this.addContentTimestamps(parameters, signedAttributes);
        return new AttributeTable(signedAttributes);
    }

    private void addSignerAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List<String> claimedSignerRoles = parameters.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute id_aa_ets_signerAttr = new Attribute(OID.id_at_role, new DERSet(roles));
                claimedAttributes.add(id_aa_ets_signerAttr);
            }
            org.bouncycastle.asn1.cms.Attribute signerAttributes = !parameters.isEn319122() ? new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, new DERSet(new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()])))) : new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, new DERSet(new SignerAttributeV2(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
            signedAttributes.add(signerAttributes);
            return;
        }
        List<String> signedAssertions = parameters.bLevel().getSignedAssertions();
        if (signedAssertions != null && parameters.isEn319122()) {
            ArrayList<SignedAssertion> assertionsToAdd = new ArrayList<SignedAssertion>();
            for (String signedAssertion : signedAssertions) {
                SignedAssertion sa = new SignedAssertion(signedAssertion);
                assertionsToAdd.add(sa);
            }
            if (!assertionsToAdd.isEmpty()) {
                org.bouncycastle.asn1.cms.Attribute signerAttributes = new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, new DERSet(new SignerAttributeV2(new SignedAssertions(assertionsToAdd))));
                signedAttributes.add(signerAttributes);
            }
        }
    }

    private void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate != null) {
            DERSet attrValues = new DERSet(new Time(signingDate));
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        eu.europa.esig.dss.model.SignerLocation signerLocationParameter = parameters.bLevel().getSignerLocation();
        if (signerLocationParameter != null && !signerLocationParameter.isEmpty()) {
            DERUTF8String country = signerLocationParameter.getCountry() == null ? null : new DERUTF8String(signerLocationParameter.getCountry());
            DERUTF8String locality = signerLocationParameter.getLocality() == null ? null : new DERUTF8String(signerLocationParameter.getLocality());
            DERSequence derSequencePostalAddress = this.getPostalAddressSequence(signerLocationParameter.getPostalAddress());
            SignerLocation signerLocation = new SignerLocation(country, locality, (ASN1Sequence)derSequencePostalAddress);
            DERSet attrValues = new DERSet(signerLocation);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private DERSequence getPostalAddressSequence(List<String> postalAddressParameter) {
        DERSequence derSequencePostalAddress = null;
        if (Utils.isCollectionNotEmpty(postalAddressParameter)) {
            ASN1EncodableVector postalAddress = new ASN1EncodableVector();
            for (String addressLine : postalAddressParameter) {
                postalAddress.add(new DERUTF8String(addressLine));
            }
            derSequencePostalAddress = new DERSequence(postalAddress);
        }
        return derSequencePostalAddress;
    }

    private void addCommitmentType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List<CommitmentType> commitmentTypeIndications = parameters.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            int size = commitmentTypeIndications.size();
            ASN1Encodable[] asn1Encodables = new ASN1Encodable[size];
            for (int ii = 0; ii < size; ++ii) {
                CommitmentType commitmentType = commitmentTypeIndications.get(ii);
                if (Utils.isStringEmpty(commitmentType.getOid())) {
                    throw new IllegalArgumentException("The commitmentTypeIndication OID must be defined for CAdES creation!");
                }
                ASN1ObjectIdentifier objectIdentifier = new ASN1ObjectIdentifier(commitmentType.getOid());
                ASN1Sequence qualifiers = this.getCommitmentQualifiers(commitmentType);
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(objectIdentifier, qualifiers);
                asn1Encodables[ii] = commitmentTypeIndication.toASN1Primitive();
            }
            DERSet attrValues = new DERSet(asn1Encodables);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private ASN1Sequence getCommitmentQualifiers(CommitmentType commitmentType) {
        Object[] commitmentTypeQualifiers;
        DERSequence qualifiers = null;
        if (commitmentType instanceof CommonCommitmentType && Utils.isArrayNotEmpty(commitmentTypeQualifiers = ((CommonCommitmentType)commitmentType).getCommitmentTypeQualifiers())) {
            ASN1EncodableVector vector = new ASN1EncodableVector(commitmentTypeQualifiers.length);
            for (Object commitmentQualifier : commitmentTypeQualifiers) {
                Object qualifier;
                Objects.requireNonNull(commitmentQualifier, "CommitmentTypeQualifier cannot be null!");
                if (Utils.isStringEmpty(((CommitmentQualifier)commitmentQualifier).getOid())) {
                    throw new IllegalArgumentException("CommitmentTypeQualifier OID cannot be null for CAdES!");
                }
                ASN1ObjectIdentifier commitmentIdentifier = new ASN1ObjectIdentifier(((CommitmentQualifier)commitmentQualifier).getOid());
                DSSDocument content = ((CommitmentQualifier)commitmentQualifier).getContent();
                if (content == null) {
                    throw new IllegalArgumentException("CommitmentTypeQualifier content cannot be null!");
                }
                byte[] binaries = DSSUtils.toByteArray(content);
                if (DSSASN1Utils.isAsn1Encoded(binaries)) {
                    qualifier = DSSASN1Utils.toASN1Primitive(binaries);
                } else {
                    LOG.info("None ASN.1 encoded CommitmentTypeQualifier has been provided. Incorporate as DERUTF8String.");
                    qualifier = new DERUTF8String(new String(binaries));
                }
                vector.add(new CommitmentTypeQualifier(commitmentIdentifier, (ASN1Encodable)qualifier));
            }
            qualifiers = new DERSequence(vector);
        }
        return qualifiers;
    }

    private void addContentTimestamps(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isCollectionNotEmpty(parameters.getContentTimestamps())) {
            List<TimestampToken> contentTimestamps = parameters.getContentTimestamps();
            for (TimestampToken contentTimestamp : contentTimestamps) {
                Object asn1Object = DSSASN1Utils.toASN1Primitive(contentTimestamp.getEncoded());
                DERSet attrValues = new DERSet((ASN1Encodable)asn1Object);
                org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, attrValues);
                signedAttributes.add(attribute);
            }
        }
    }

    private void addContentHints(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isStringNotBlank(parameters.getContentHintsType())) {
            ASN1ObjectIdentifier contentHintsType = new ASN1ObjectIdentifier(parameters.getContentHintsType());
            String contentHintsDescriptionString = parameters.getContentHintsDescription();
            DERUTF8String contentHintsDescription = Utils.isStringBlank(contentHintsDescriptionString) ? null : new DERUTF8String(contentHintsDescriptionString);
            ContentHints contentHints = new ContentHints(contentHintsType, contentHintsDescription);
            DERSet attrValues = new DERSet(contentHints);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentHint, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        String contentIdentifierPrefix = parameters.getContentIdentifierPrefix();
        if (Utils.isStringNotBlank(contentIdentifierPrefix)) {
            if (Utils.isStringBlank(parameters.getContentIdentifierSuffix())) {
                StringBuilder suffixBuilder = new StringBuilder();
                suffixBuilder.append(new ASN1GeneralizedTime(new Date()).getTimeString());
                suffixBuilder.append(new SecureRandom().nextLong());
                parameters.setContentIdentifierSuffix(suffixBuilder.toString());
            }
            String contentIdentifierString = contentIdentifierPrefix + parameters.getContentIdentifierSuffix();
            ContentIdentifier contentIdentifier = new ContentIdentifier(contentIdentifierString.getBytes());
            DERSet attrValues = new DERSet(contentIdentifier);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addSignaturePolicyId(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Policy policy = parameters.bLevel().getSignaturePolicy();
        if (policy != null) {
            SignaturePolicyIdentifier sigPolicy;
            String policyId = policy.getId();
            if (Utils.isStringEmpty(policyId)) {
                sigPolicy = new SignaturePolicyIdentifier();
            } else {
                ASN1ObjectIdentifier derOIPolicyId = new ASN1ObjectIdentifier(policyId);
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getDigestAlgorithm().getOid());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oid);
                OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, new DEROctetString(policy.getDigestValue()));
                if (policy.isSPQualifierPresent()) {
                    SigPolicyQualifiers sigPolicyQualifiers = this.buildSigPolicyQualifiers(policy);
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue, sigPolicyQualifiers));
                } else {
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue));
                }
            }
            DERSet attrValues = new DERSet(sigPolicy);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private SigPolicyQualifiers buildSigPolicyQualifiers(Policy policy) {
        SpDocSpecification spDocSpecification;
        eu.europa.esig.dss.model.UserNotice userNotice;
        ArrayList<SigPolicyQualifierInfo> qualifierInfos = new ArrayList<SigPolicyQualifierInfo>();
        String spUri = policy.getSpuri();
        if (Utils.isStringNotEmpty(spUri)) {
            SigPolicyQualifierInfo spuriQualifier = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_uri, new DERIA5String(policy.getSpuri()));
            qualifierInfos.add(spuriQualifier);
        }
        if ((userNotice = policy.getUserNotice()) != null && !userNotice.isEmpty()) {
            DSSUtils.assertSPUserNoticeConfigurationValid(userNotice);
            NoticeReference noticeReference = null;
            String explicitText = null;
            String organization = userNotice.getOrganization();
            int[] noticeNumbers = userNotice.getNoticeNumbers();
            if (Utils.isStringNotEmpty(organization) && noticeNumbers != null && noticeNumbers.length > 0) {
                Vector<BigInteger> numbers = new Vector<BigInteger>(DSSUtils.toBigIntegerList(noticeNumbers));
                noticeReference = new NoticeReference(organization, numbers);
            }
            if (Utils.isStringNotEmpty(userNotice.getExplicitText())) {
                explicitText = userNotice.getExplicitText();
            }
            UserNotice asn1UserNotice = new UserNotice(noticeReference, explicitText);
            SigPolicyQualifierInfo userNoticeQualifier = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_unotice, asn1UserNotice);
            qualifierInfos.add(userNoticeQualifier);
        }
        if ((spDocSpecification = policy.getSpDocSpecification()) != null && Utils.isStringNotEmpty(spDocSpecification.getId())) {
            ASN1Primitive spDocSpecificationId = DSSASN1Utils.buildSPDocSpecificationId(spDocSpecification.getId());
            SigPolicyQualifierInfo spDocSpecificationQualifier = new SigPolicyQualifierInfo(OID.id_sp_doc_specification, spDocSpecificationId);
            qualifierInfos.add(spDocSpecificationQualifier);
        }
        return new SigPolicyQualifiers(qualifierInfos.toArray(new SigPolicyQualifierInfo[0]));
    }

    private void addSigningCertificateAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signed attributes later");
            return;
        }
        CMSUtils.addSigningCertificateAttribute(signedAttributes, parameters.getDigestAlgorithm(), parameters.getSigningCertificate());
    }

    private void addMimeType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        if (parameters instanceof CAdESCounterSignatureParameters) {
            return;
        }
        if (Utils.isStringNotBlank(parameters.getContentHintsType())) {
            return;
        }
        MimeType mimeType = MimeType.BINARY;
        if (this.documentToSign != null && this.documentToSign.getMimeType() != null) {
            mimeType = this.documentToSign.getMimeType();
        }
        DERUTF8String mimeTypeDerString = new DERUTF8String(mimeType.getMimeTypeString());
        DERSet attrValues = new DERSet(mimeTypeDerString);
        org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_mimeType, attrValues);
        signedAttributes.add(attribute);
    }
}

