/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;

public class ASiCWithCAdESSignatureScopeFinder
extends CAdESSignatureScopeFinder {
    @Override
    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        if (originalDocument == null) {
            return result;
        }
        if (this.isASiCSArchive(cadesSignature) && this.isASiCSContainer(originalDocument)) {
            ContainerSignatureScope containerSignatureScope = new ContainerSignatureScope(originalDocument.getName(), DSSUtils.getDigest(this.getDefaultDigestAlgorithm(), originalDocument));
            result.add(containerSignatureScope);
            for (DSSDocument archivedDocument : cadesSignature.getContainerContents()) {
                containerSignatureScope.addChildSignatureScope(new ContainerContentSignatureScope(DSSUtils.decodeURI(archivedDocument.getName()), this.getDigest(archivedDocument)));
            }
        } else if (this.isASiCEArchive(cadesSignature)) {
            ManifestFile manifestFile = cadesSignature.getManifestFile();
            ManifestSignatureScope manifestSignatureScope = new ManifestSignatureScope(manifestFile.getFilename(), new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64(manifestFile.getDigestBase64String(this.getDefaultDigestAlgorithm()))));
            result.add(manifestSignatureScope);
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!manifestEntry.isIntact()) continue;
                manifestSignatureScope.addChildSignatureScope(new FullSignatureScope(manifestEntry.getFileName(), manifestEntry.getDigest()));
            }
        } else {
            return this.getSignatureScopeFromOriginalDocument(cadesSignature, originalDocument);
        }
        return result;
    }

    @Override
    protected boolean isASiCSArchive(AdvancedSignature advancedSignature) {
        return !super.isASiCEArchive(advancedSignature);
    }

    private boolean isASiCSContainer(DSSDocument document) {
        return document.getName() != null && !document.getName().contains("/") && ASiCUtils.isZip(document);
    }
}

