/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.definition.ASiCAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.asic.common.definition.ASiCPaths;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ASiCWithCAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESManifestParser.class);

    private ASiCWithCAdESManifestParser() {
    }

    public static ManifestFile getManifestFile(DSSDocument manifestDocument) {
        Element root = ASiCWithCAdESManifestParser.getManifestRootElement(manifestDocument);
        if (root == null) {
            return null;
        }
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(manifestDocument);
        manifest.setSignatureFilename(ASiCWithCAdESManifestParser.getLinkedSignatureName(root));
        manifest.setEntries(ASiCWithCAdESManifestParser.parseManifestEntries(root));
        manifest.setTimestampManifest(ASiCWithCAdESManifestParser.isTimestampAssociatedManifest(root));
        manifest.setArchiveManifest(ASiCUtils.isArchiveManifest(manifestDocument.getName()));
        return manifest;
    }

    public static DSSDocument getLinkedManifest(List<DSSDocument> manifestDocuments, String signatureName) {
        for (DSSDocument manifest : manifestDocuments) {
            String linkedSignatureName;
            Element manifestRoot = ASiCWithCAdESManifestParser.getManifestRootElement(manifest);
            if (manifestRoot == null || !signatureName.equals(linkedSignatureName = DSSUtils.decodeURI(ASiCWithCAdESManifestParser.getLinkedSignatureName(manifestRoot)))) continue;
            return manifest;
        }
        return null;
    }

    private static Element getManifestRootElement(DSSDocument manifestDocument) {
        if (!DomUtils.isDOM(manifestDocument)) {
            LOG.warn("Unable to analyze manifest file '{}' : Not a valid XML file!", (Object)manifestDocument.getName());
            return null;
        }
        try {
            Document manifestDom = DomUtils.buildDOM(manifestDocument);
            return DomUtils.getElement(manifestDom, ASiCPaths.ASIC_MANIFEST_PATH);
        }
        catch (Exception e) {
            LOG.warn("Unable to analyze manifest file '{}' : {}", (Object)manifestDocument.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private static String getLinkedSignatureName(Element root) {
        return DomUtils.getValue(root, ASiCPaths.SIG_REFERENCE_URI_PATH);
    }

    private static MimeType getMimeType(Element element) {
        try {
            String mimeTypeString = element.getAttribute(ASiCAttribute.MIME_TYPE.getAttributeName());
            if (Utils.isStringNotBlank(mimeTypeString)) {
                return MimeType.fromMimeTypeString(mimeTypeString);
            }
        }
        catch (DSSException e) {
            LOG.warn("Cannot extract MimeType for a reference. Reason : [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static DigestAlgorithm getDigestAlgorithm(Element dataObjectReference) {
        String value = null;
        try {
            value = DomUtils.getValue(dataObjectReference, XMLDSigPaths.DIGEST_METHOD_ALGORITHM_PATH);
            return DigestAlgorithm.forXML(value);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to extract DigestAlgorithm (value = {}). Reason : [{}]", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    private static byte[] getDigestValue(Element dataObjectReference) {
        Element digestValueElement = DomUtils.getElement(dataObjectReference, XMLDSigPaths.DIGEST_VALUE_PATH);
        if (digestValueElement != null) {
            try {
                return Utils.fromBase64(digestValueElement.getTextContent());
            }
            catch (Exception e) {
                LOG.warn("Unable to extract DigestValue. Reason : [{}]", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static boolean isTimestampAssociatedManifest(Element root) {
        Element sigReference = DomUtils.getElement(root, ASiCPaths.SIG_REFERENCE_PATH);
        if (sigReference != null) {
            MimeType mimeType = ASiCWithCAdESManifestParser.getMimeType(sigReference);
            return MimeType.TST == mimeType;
        }
        return false;
    }

    private static List<ManifestEntry> parseManifestEntries(Element root) {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        NodeList dataObjectReferences = DomUtils.getNodeList(root, ASiCPaths.DATA_OBJECT_REFERENCE_PATH);
        if (dataObjectReferences == null || dataObjectReferences.getLength() == 0) {
            LOG.warn("No DataObjectReference found in manifest file");
        } else {
            for (int i = 0; i < dataObjectReferences.getLength(); ++i) {
                String attribute;
                ManifestEntry entry = new ManifestEntry();
                Element dataObjectReference = (Element)dataObjectReferences.item(i);
                entry.setFileName(DSSUtils.decodeURI(dataObjectReference.getAttribute(ASiCAttribute.URI.getAttributeName())));
                entry.setMimeType(ASiCWithCAdESManifestParser.getMimeType(dataObjectReference));
                DigestAlgorithm digestAlgorithm = ASiCWithCAdESManifestParser.getDigestAlgorithm(dataObjectReference);
                byte[] digestValueBinary = ASiCWithCAdESManifestParser.getDigestValue(dataObjectReference);
                if (digestAlgorithm != null && digestValueBinary != null) {
                    entry.setDigest(new Digest(digestAlgorithm, digestValueBinary));
                }
                if (Utils.areStringsEqualIgnoreCase("true", attribute = dataObjectReference.getAttribute(ASiCAttribute.ROOTFILE.getAttributeName()))) {
                    entry.setRootfile(true);
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    static {
        DomUtils.registerNamespace(XMLDSigNamespace.NS);
        DomUtils.registerNamespace(ASiCNamespace.NS);
    }
}

