/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.merge;

import eu.europa.esig.dss.asic.cades.merge.AbstractASiCWithCAdESContainerMerger;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ASiCSWithCAdESContainerMerger
extends AbstractASiCWithCAdESContainerMerger {
    ASiCSWithCAdESContainerMerger() {
    }

    public ASiCSWithCAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCSWithCAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    public boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && !ASiCUtils.isASiCEContainer(container);
    }

    @Override
    public boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && !ASiCUtils.isASiCEContainer(asicContent);
    }

    @Override
    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_S;
    }

    @Override
    protected void ensureContainerContentAllowMerge() {
        if (Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty(asicContent.getSignatureDocuments())) && Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty(asicContent.getTimestampDocuments()))) {
            return;
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize(asicContent.getSignatureDocuments()) + Utils.collectionSize(asicContent.getTimestampDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. One of the containers has more than one signature or timestamp documents!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments())) && Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. A container containing a timestamp file cannot be merged with other signed or timestamped container!");
        }
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments())).count() > 1L) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. Multiple containers contain detached timestamps!");
        }
        Arrays.stream(this.asicContents).forEach(asicContent -> this.assertSignatureDocumentNameValid(asicContent.getSignatureDocuments()));
        Arrays.stream(this.asicContents).forEach(asicContent -> this.assertTimestampDocumentNameValid(asicContent.getTimestampDocuments()));
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize(asicContent.getRootLevelSignedDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. One of the containers has more than one signer documents!");
        }
        if (!this.checkRootSignerDocumentsNames()) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. Signer documents have different names!");
        }
    }

    private void assertSignatureDocumentNameValid(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionNotEmpty(signatureDocuments)) {
            for (DSSDocument signatureDocument : signatureDocuments) {
                if ("META-INF/signature.p7s".equals(signatureDocument.getName())) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. The signature document in one of the containers has invalid naming!");
            }
        }
    }

    private void assertTimestampDocumentNameValid(List<DSSDocument> timestampDocuments) {
        if (Utils.isCollectionNotEmpty(timestampDocuments)) {
            for (DSSDocument tstDocument : timestampDocuments) {
                if ("META-INF/timestamp.tst".equals(tstDocument.getName())) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-S with CAdES containers. The timestamp document in one of the containers has invalid naming!");
            }
        }
    }

    private boolean checkRootSignerDocumentsNames() {
        String rootSignedDocumentName = null;
        for (ASiCContent asicContent : this.asicContents) {
            List<DSSDocument> rootLevelSignedDocuments = asicContent.getRootLevelSignedDocuments();
            if (!Utils.isCollectionNotEmpty(rootLevelSignedDocuments)) continue;
            DSSDocument currentSignedDocument = rootLevelSignedDocuments.get(0);
            if (rootSignedDocumentName == null) {
                rootSignedDocumentName = currentSignedDocument.getName();
                continue;
            }
            return rootSignedDocumentName.equals(currentSignedDocument.getName());
        }
        return true;
    }

    @Override
    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments())).count() <= 1L) {
            return;
        }
        List<DSSDocument> allSignatureDocuments = this.getAllSignatureDocuments(this.asicContents);
        DSSDocument mergedCMSSignaturesDocument = this.mergeCmsSignatures(allSignatureDocuments);
        for (ASiCContent asicContent2 : this.asicContents) {
            asicContent2.setSignatureDocuments(Collections.singletonList(mergedCMSSignaturesDocument));
        }
    }
}

