/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.merge;

import eu.europa.esig.dss.asic.cades.merge.AbstractASiCWithCAdESContainerMerger;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ASiCEWithCAdESContainerMerger
extends AbstractASiCWithCAdESContainerMerger {
    ASiCEWithCAdESContainerMerger() {
    }

    public ASiCEWithCAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCEWithCAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && (!ASiCUtils.isASiCSContainer(container) || this.doesNotContainSignatures(container));
    }

    private boolean doesNotContainSignatures(DSSDocument container) {
        List<String> entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainSignatures(entryNames);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && (!ASiCUtils.isASiCSContainer(asicContent) || this.doesNotContainSignatures(asicContent));
    }

    private boolean doesNotContainSignatures(ASiCContent asicContent) {
        return Utils.isCollectionEmpty(asicContent.getSignatureDocuments());
    }

    @Override
    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_E;
    }

    @Override
    protected void ensureContainerContentAllowMerge() {
    }

    @Override
    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments())).count() <= 1L) {
            return;
        }
        this.ensureSignatureDocumentsValid();
        this.ensureManifestDocumentsValid();
    }

    private void ensureSignatureDocumentsValid() {
        ArrayList<String> mergedSignatureNames = new ArrayList<String>();
        ArrayList<ASiCContent> asicContentsToProcess = new ArrayList<ASiCContent>(Arrays.asList(this.asicContents));
        Iterator iterator = asicContentsToProcess.iterator();
        while (iterator.hasNext()) {
            ASiCContent asicContent = (ASiCContent)iterator.next();
            iterator.remove();
            ArrayList<DSSDocument> signatureDocumentList = new ArrayList<DSSDocument>(asicContent.getSignatureDocuments());
            for (DSSDocument signatureDocument : signatureDocumentList) {
                List<DSSDocument> signaturesToMerge;
                if (mergedSignatureNames.contains(signatureDocument.getName()) || !Utils.isCollectionNotEmpty(signaturesToMerge = this.getSignatureDocumentsToBeMerged(asicContent, signatureDocument, asicContentsToProcess))) continue;
                signaturesToMerge.add(signatureDocument);
                mergedSignatureNames.add(signatureDocument.getName());
                DSSDocument signaturesCms = this.mergeCmsSignatures(signaturesToMerge);
                this.updateMergedSignatureInContainers(signaturesCms);
            }
        }
    }

    private List<DSSDocument> getSignatureDocumentsToBeMerged(ASiCContent currentASiCContent, DSSDocument currentSignatureDocument, List<ASiCContent> asicContentList) {
        if (currentSignatureDocument.getName() == null) {
            throw new IllegalInputException("Name shall be provided for a document!");
        }
        DSSDocument manifest = ASiCWithCAdESManifestParser.getLinkedManifest(currentASiCContent.getAllManifestDocuments(), currentSignatureDocument.getName());
        if (manifest == null) {
            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with filename '%s' does not have a corresponding manifest file!", currentSignatureDocument.getName()));
        }
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ASiCContent asicContentToCompare : asicContentList) {
            DSSDocument signatureToCompare = DSSUtils.getDocumentWithName(asicContentToCompare.getSignatureDocuments(), currentSignatureDocument.getName());
            if (signatureToCompare == null) continue;
            DSSDocument manifestToCompare = ASiCWithCAdESManifestParser.getLinkedManifest(asicContentToCompare.getAllManifestDocuments(), signatureToCompare.getName());
            if (manifestToCompare == null) {
                throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with filename '%s' does not have a corresponding manifest file!", signatureToCompare.getName()));
            }
            if (ASiCWithCAdESUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentSignatureDocument.getName()) || ASiCWithCAdESUtils.isCoveredByManifest(asicContentToCompare.getAllManifestDocuments(), signatureToCompare.getName())) {
                throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A signature with name '%s' in a container is covered by a manifest!", currentSignatureDocument.getName()));
            }
            if (manifest.getName().equals(manifestToCompare.getName()) && manifest.getDigest(DEFAULT_DIGEST_ALGORITHM).equals(manifestToCompare.getDigest(DEFAULT_DIGEST_ALGORITHM))) {
                result.add(signatureToCompare);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. Signatures with filename '%s' sign different manifests!", currentSignatureDocument.getName()));
        }
        return result;
    }

    private void updateMergedSignatureInContainers(DSSDocument mergedCmsSignature) {
        for (ASiCContent asicContent : this.asicContents) {
            if (!DSSUtils.getDocumentNames(asicContent.getSignatureDocuments()).contains(mergedCmsSignature.getName())) continue;
            ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), mergedCmsSignature);
        }
    }

    private void ensureManifestDocumentsValid() {
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getManifestDocuments().addAll(asicContent.getManifestDocuments());
            mergedASiCContent.getArchiveManifestDocuments().addAll(asicContent.getArchiveManifestDocuments());
        }
        ArrayList<ASiCContent> asicContentsToProcess = new ArrayList<ASiCContent>(Arrays.asList(this.asicContents));
        Iterator iterator = asicContentsToProcess.iterator();
        while (iterator.hasNext()) {
            String newManifestName;
            ASiCContent asicContent = (ASiCContent)iterator.next();
            iterator.remove();
            for (DSSDocument manifest : asicContent.getManifestDocuments()) {
                for (ASiCContent currentASiCContent : asicContentsToProcess) {
                    for (DSSDocument currentManifest : currentASiCContent.getManifestDocuments()) {
                        if (manifest.getName() == null || !manifest.getName().equals(currentManifest.getName()) || manifest.getDigest(DEFAULT_DIGEST_ALGORITHM).equals(currentManifest.getDigest(DEFAULT_DIGEST_ALGORITHM))) continue;
                        if (ASiCWithCAdESUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), manifest.getName()) || ASiCWithCAdESUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentManifest.getName())) {
                            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A manifest with name '%s' in a container is covered by another manifest!", currentManifest.getName()));
                        }
                        newManifestName = this.asicFilenameFactory.getManifestFilename(mergedASiCContent);
                        currentManifest.setName(newManifestName);
                    }
                }
            }
            for (DSSDocument manifest : asicContent.getArchiveManifestDocuments()) {
                for (ASiCContent currentASiCContent : asicContentsToProcess) {
                    for (DSSDocument currentManifest : currentASiCContent.getArchiveManifestDocuments()) {
                        if (manifest.getName() == null || !manifest.getName().equals(currentManifest.getName()) || manifest.getDigest(DEFAULT_DIGEST_ALGORITHM).equals(currentManifest.getDigest(DEFAULT_DIGEST_ALGORITHM))) continue;
                        if (ASiCWithCAdESUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), manifest.getName()) || ASiCWithCAdESUtils.isCoveredByManifest(currentASiCContent.getAllManifestDocuments(), currentManifest.getName())) {
                            throw new UnsupportedOperationException(String.format("Unable to merge ASiC-E with CAdES containers. A manifest with name '%s' in a container is covered by another manifest!", currentManifest.getName()));
                        }
                        newManifestName = this.asicFilenameFactory.getArchiveManifestFilename(mergedASiCContent);
                        currentManifest.setName(newManifestName);
                    }
                }
            }
        }
    }
}

