/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.model.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.SignatureParametersBuilder;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSignatureParametersBuilder<SP extends AbstractSignatureParameters>
implements SignatureParametersBuilder<SP> {
    private final CertificateToken signingCertificate;
    private List<CertificateToken> certificateChain;
    private BLevelParameters bLevelParams = new BLevelParameters();

    protected AbstractSignatureParametersBuilder(CertificateToken signingCertificate) {
        this(signingCertificate, new LinkedList<CertificateToken>());
    }

    protected AbstractSignatureParametersBuilder(CertificateToken signingCertificate, List<CertificateToken> certificateChain) {
        this.signingCertificate = signingCertificate;
        this.certificateChain = certificateChain;
    }

    protected abstract SP initParameters();

    public BLevelParameters bLevel() {
        return this.bLevelParams;
    }

    public AbstractSignatureParametersBuilder<SP> setBLevelParams(BLevelParameters bLevelParams) {
        this.bLevelParams = bLevelParams;
        return this;
    }

    @Override
    public SP build() {
        SP signatureParameters = this.initParameters();
        ((AbstractSignatureParameters)signatureParameters).setSigningCertificate(this.signingCertificate);
        ((AbstractSignatureParameters)signatureParameters).setCertificateChain(this.certificateChain);
        ((AbstractSerializableSignatureParameters)signatureParameters).setBLevelParams(this.bLevelParams);
        return signatureParameters;
    }
}

